/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import junit.framework.TestCase;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.TryDefinition;

public class DoCatchCaughExceptionIssueTest
extends ContextTestSupport {
    public void testSendThatIsCaught() {
        String out = (String)this.template.requestBody("direct:test", (Object)"test", String.class);
        DoCatchCaughExceptionIssueTest.assertEquals((String)"Forced by me but I fixed it", (String)out);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.errorHandler((ErrorHandlerBuilder)this.noErrorHandler());
                ((TryDefinition)((TryDefinition)this.from("direct:test").doTry().throwException((Exception)new IllegalArgumentException("Forced by me"))).doCatch(Exception.class).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        Exception error = (Exception)exchange.getProperty("CamelExceptionCaught", Exception.class);
                        TestCase.assertEquals((String)"Forced by me", (String)error.getMessage());
                        exchange.getOut().setBody((Object)(error.getMessage() + " but I fixed it"));
                    }
                })).end();
            }
        };
    }
}

