/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Predicate;
import org.apache.camel.builder.PredicateBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.InterceptDefinition;

public class InterceptCustomPredicateAsFilterTest
extends ContextTestSupport {
    private MyFiler filter = new MyFiler();

    public void testInterceptCustomPredicateAsFilter() throws Exception {
        this.getMockEndpoint("mock:good").expectedBodiesReceived(new Object[]{"Hello World", "Bye World"});
        this.getMockEndpoint("mock:secret").expectedBodiesReceived(new Object[]{"secret"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:start", (Object)"secret");
        this.template.sendBody("direct:start", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
        InterceptCustomPredicateAsFilterTest.assertEquals((String)"Hello World", (String)this.filter.getBodies().get(0));
        InterceptCustomPredicateAsFilterTest.assertEquals((String)"secret", (String)this.filter.getBodies().get(1));
        InterceptCustomPredicateAsFilterTest.assertEquals((String)"Bye World", (String)this.filter.getBodies().get(2));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((InterceptDefinition)this.intercept().when(PredicateBuilder.not((Predicate)InterceptCustomPredicateAsFilterTest.this.filter)).to("mock:secret")).stop();
                this.from("direct:start").to("mock:good");
            }
        };
    }

    private static class MyFiler
    implements Predicate {
        private List<String> bodies = new ArrayList<String>();

        private MyFiler() {
        }

        public boolean matches(Exchange exchange) {
            String body = (String)exchange.getIn().getBody(String.class);
            this.bodies.add(body);
            return !"secret".equals(body);
        }

        public List<String> getBodies() {
            return this.bodies;
        }
    }
}

