/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.OnCompletionDefinition;

public class OnCompletionIssueTest
extends ContextTestSupport {
    public void testOnCompletionIssue() throws Exception {
        MockEndpoint end = this.getMockEndpoint("mock:end");
        end.expectedMessageCount(1);
        MockEndpoint complete = this.getMockEndpoint("mock:complete");
        complete.expectedBodiesReceived(new Object[]{"finish", "stop", "faulted", "except"});
        this.template.sendBody("direct:input", (Object)"finish");
        this.template.sendBody("direct:input", (Object)"stop");
        this.template.sendBody("direct:input", (Object)"fault");
        this.template.sendBody("direct:input", (Object)"except");
        this.setAssertPeriod(2000L);
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((OnCompletionDefinition)this.onCompletion().log("completing ${body}")).to("mock:complete");
                ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)this.from("direct:input").onException(Exception.class).handled(true).end().choice().when((Predicate)this.simple("${body} == 'stop'")).log("stopping")).stop()).when((Predicate)this.simple("${body} == 'fault'")).log("faulting")).setFaultBody((Expression)this.constant("faulted"))).when((Predicate)this.simple("${body} == 'except'")).log("excepting")).throwException(new Exception("Exception requested"))).end().log("finishing").to("mock:end");
            }
        };
    }
}

