/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.builder.DeadLetterChannelBuilder;
import org.apache.camel.builder.ErrorHandlerBuilderRef;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.RouteDefinition;

public class OnExceptionRouteScopedErrorHandlerRefIssueTwoRoutesTest
extends ContextTestSupport {
    public void testOnExceptionErrorHandlerRef() throws Exception {
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:handled").expectedMessageCount(1);
        this.getMockEndpoint("mock:dead").expectedMessageCount(0);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testOnExceptionErrorHandlerRefFoo() throws Exception {
        this.getMockEndpoint("mock:a").expectedMessageCount(0);
        this.getMockEndpoint("mock:handled").expectedMessageCount(0);
        this.getMockEndpoint("mock:dead").expectedMessageCount(1);
        this.template.sendBody("direct:foo", (Object)"Hello Foo");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("myDLC", (Object)new DeadLetterChannelBuilder("mock:dead"));
        return jndi;
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:foo").errorHandler((ErrorHandlerFactory)new ErrorHandlerBuilderRef("myDLC")).to("mock:foo")).throwException((Exception)new IllegalArgumentException("Damn Foo"));
                ((OnExceptionDefinition)this.from("direct:start").errorHandler((ErrorHandlerFactory)new ErrorHandlerBuilderRef("myDLC")).onException(IllegalArgumentException.class).handled(true).to("mock:handled")).end().to("mock:a").throwException((Exception)new IllegalArgumentException("Damn"));
            }
        };
    }
}

