/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.builder.DeadLetterChannelBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.spi.Registry;

public class RouteScopedOnExceptionMultipleRouteBuildersTest
extends ContextTestSupport {
    public void testOnExceptionErrorHandlerRef() throws Exception {
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.getMockEndpoint("mock:handled").expectedMessageCount(0);
        this.getMockEndpoint("mock:dead").expectedMessageCount(0);
        this.getMockEndpoint("mock:exc").expectedMessageCount(1);
        this.template.sendBody("direct:foo", (Object)"Hello Foo");
        this.assertMockEndpointsSatisfied();
    }

    public void testOnExceptionErrorHandlerRefFoo() throws Exception {
        this.getMockEndpoint("mock:bar").expectedMessageCount(1);
        this.getMockEndpoint("mock:handled").expectedMessageCount(1);
        this.getMockEndpoint("mock:dead").expectedMessageCount(0);
        this.getMockEndpoint("mock:exc").expectedMessageCount(0);
        this.template.sendBody("direct:bar", (Object)"Hello Bar");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext((Registry)this.createRegistry());
        context.setErrorHandlerBuilder((ErrorHandlerFactory)new DeadLetterChannelBuilder("mock:dead"));
        context.setLazyLoadTypeConverters(Boolean.valueOf(this.isLazyLoadingTypeConverter()));
        return context;
    }

    @Override
    protected RouteBuilder[] createRouteBuilders() throws Exception {
        return new RouteBuilder[]{new RouteBuilder(){

            public void configure() throws Exception {
                ((OnExceptionDefinition)this.from("direct:bar").onException(IllegalArgumentException.class).handled(true).to("mock:handled")).end().to("mock:bar").throwException((Exception)new IllegalArgumentException("Damn"));
            }
        }, new RouteBuilder(){

            public void configure() throws Exception {
                ((OnExceptionDefinition)this.from("direct:foo").onException(Exception.class).handled(true).to("mock:exc")).end().to("mock:foo").throwException((Exception)new IllegalArgumentException("Damn"));
            }
        }};
    }
}

