/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.SplitDefinition;

public class SplitStopOnExceptionIssueTest
extends ContextTestSupport {
    public void testSplit() throws Exception {
        this.getMockEndpoint("mock:line").expectedBodiesReceived(new Object[]{"Hello", "World", "Kaboom"});
        ((ValueBuilder)this.getMockEndpoint("mock:line").allMessages().property("foo")).isEqualTo((Object)"changed");
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        Exchange out = this.template.request("direct:start", new Processor(){

            public void process(Exchange exchange) throws Exception {
                exchange.getIn().setBody((Object)"Hello,World,Kaboom");
            }
        });
        SplitStopOnExceptionIssueTest.assertNotNull((Object)out);
        SplitStopOnExceptionIssueTest.assertTrue((boolean)out.isFailed());
        SplitStopOnExceptionIssueTest.assertFalse((boolean)out.hasOut());
        SplitStopOnExceptionIssueTest.assertEquals((Object)"before", (Object)out.getProperty("foo"));
        SplitStopOnExceptionIssueTest.assertEquals((Object)"Hello,World,Kaboom", (Object)out.getIn().getBody());
        IllegalArgumentException iae = (IllegalArgumentException)out.getException(IllegalArgumentException.class);
        SplitStopOnExceptionIssueTest.assertNotNull((Object)iae);
        SplitStopOnExceptionIssueTest.assertEquals((String)"Forced exception", (String)iae.getMessage());
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((ExpressionNode)((ExpressionNode)((ExpressionNode)((SplitDefinition)((RouteDefinition)this.from("direct:start").setProperty("foo", (Expression)this.constant("before"))).split().tokenize(",")).setProperty("foo", (Expression)this.constant("changed"))).to("mock:line")).filter(this.body().contains((Object)"Kaboom")).throwException((Exception)new IllegalArgumentException("Forced exception"))).end().end().to("mock:result");
            }
        };
    }
}

