/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.RouteDefinition;

public class StopCamelFromRouteTest
extends TestCase {
    private final CountDownLatch latch = new CountDownLatch(1);

    public void testStopCamelFromRoute() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext();
        context.addRoutes((RoutesBuilder)this.createMyRoutes());
        context.start();
        MockEndpoint start = (MockEndpoint)context.getEndpoint("mock:start", MockEndpoint.class);
        start.expectedMessageCount(1);
        MockEndpoint done = (MockEndpoint)context.getEndpoint("mock:done", MockEndpoint.class);
        done.expectedMessageCount(1);
        ProducerTemplate template = context.createProducerTemplate();
        template.sendBody("direct:start", (Object)"Hello Camel");
        StopCamelFromRouteTest.assertTrue((boolean)this.latch.await(1L, TimeUnit.MINUTES));
        context.stop();
        start.assertIsSatisfied();
        done.assertIsSatisfied();
    }

    public RouteBuilder createMyRoutes() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").routeId("myRoute").to("mock:start")).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        StopCamelFromRouteTest.this.latch.countDown();
                    }
                })).to("mock:done");
            }
        };
    }
}

