/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.TryDefinition;

public class TryCatchWithSplitIssueTest
extends ContextTestSupport {
    public void testSplitWithErrorIsHandled() throws Exception {
        MockEndpoint error = this.getMockEndpoint("mock:error");
        error.expectedBodiesReceived(new Object[]{"James"});
        ((ValueBuilder)error.message(0).property("CamelExceptionCaught")).isNotNull();
        ((ValueBuilder)error.message(0).property("CamelExceptionCaught")).convertTo(String.class).isEqualTo((Object)"This is a dummy error James!");
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedBodiesReceived(new Object[]{"Hi Claus", "Hi Willem"});
        this.template.sendBody("direct:start", (Object)"Claus@James@Willem");
        this.assertMockEndpointsSatisfied();
    }

    public void testSplitOnlyWithErrorIsHandled() throws Exception {
        MockEndpoint error = this.getMockEndpoint("mock:error");
        error.expectedBodiesReceived(new Object[]{"James"});
        ((ValueBuilder)error.message(0).property("CamelExceptionCaught")).isNotNull();
        ((ValueBuilder)error.message(0).property("CamelExceptionCaught")).convertTo(String.class).isEqualTo((Object)"This is a dummy error James!");
        this.template.sendBody("direct:start", (Object)"James");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("error", (Object)new GenerateError());
        return jndi;
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                TryCatchWithSplitIssueTest.this.context.setTracing(Boolean.valueOf(true));
                ((TryDefinition)((TryDefinition)((TryDefinition)((TryDefinition)((TryDefinition)this.from("direct:start").split((Expression)this.body().tokenize("@")).doTry().to("bean:error")).to("mock:result")).doCatch(Exception.class).to("mock:error")).doFinally().to("mock:foo")).to("mock:bar")).end();
            }
        };
    }

    public static class GenerateError {
        public String dummyException(String payload) throws Exception {
            if (payload.equals("James")) {
                throw new IllegalArgumentException("This is a dummy error James!");
            }
            return "Hi " + payload;
        }
    }
}

