/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ChoiceDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XPathRouteConcurrentBigTest
extends ContextTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(XPathRouteConcurrentBigTest.class);
    private static final String XMLTEST1 = "<message><messageType>AAA</messageType><sender>0123456789101112131415</sender><rawData>Uyw7TSVkUMxUyw7TSgGUMQAyw7TSVkUMxUyA7TSgGUMQAyw7TSVkUMxUyA</rawData><sentDate>2009-10-12T12:22:02+02:00</sentDate> <receivedDate>2009-10-12T12:23:31.248+02:00</receivedDate><intproperty>1</intproperty><stringproperty>aaaaaaabbbbbbbccccccccdddddddd</stringproperty></message>";
    private static final String XMLTEST2 = "<message><messageType>AAB</messageType><sender>0123456789101112131415</sender><rawData>Uyw7TSVkUMxUyw7TSgGUMQAyw7TSVkUMxUyA7TSgGUMQAyw7TSVkUMxUyA</rawData><sentDate>2009-10-12T12:22:02+02:00</sentDate> <receivedDate>2009-10-12T12:23:31.248+02:00</receivedDate><intproperty>1</intproperty><stringproperty>aaaaaaabbbbbbbccccccccdddddddd</stringproperty></message>";
    private static final String XMLTEST3 = "<message><messageType>ZZZ</messageType><sender>0123456789101112131415</sender><rawData>Uyw7TSVkUMxUyw7TSgGUMQAyw7TSVkUMxUyA7TSgGUMQAyw7TSVkUMxUyA</rawData><sentDate>2009-10-12T12:22:02+02:00</sentDate> <receivedDate>2009-10-12T12:23:31.248+02:00</receivedDate><intproperty>1</intproperty><stringproperty>aaaaaaabbbbbbbccccccccdddddddd</stringproperty></message>";

    public void testConcurrent() throws Exception {
        this.doSendMessages(333);
    }

    private void doSendMessages(int messageCount) throws Exception {
        LOG.info("Sending " + messageCount + " messages");
        int forResult = messageCount * 2 / 3 + messageCount % 3;
        int forOther = messageCount - forResult;
        long now = System.currentTimeMillis();
        this.getMockEndpoint("mock:result").setResultWaitTime(30000L);
        this.getMockEndpoint("mock:other").setResultWaitTime(30000L);
        this.getMockEndpoint("mock:result").expectedMessageCount(forResult);
        this.getMockEndpoint("mock:other").expectedMessageCount(forOther);
        block5: for (int i = 0; i < messageCount; ++i) {
            switch (i % 3) {
                case 0: {
                    this.template.sendBody("seda:foo", (Object)XMLTEST1);
                    continue block5;
                }
                case 1: {
                    this.template.sendBody("seda:foo", (Object)XMLTEST2);
                    continue block5;
                }
                case 2: {
                    this.template.sendBody("seda:foo", (Object)XMLTEST3);
                    continue block5;
                }
            }
        }
        LOG.info("Sent " + messageCount + " messages in " + (System.currentTimeMillis() - now) + " ms");
        this.assertMockEndpointsSatisfied();
        LOG.info("Processed " + messageCount + " messages in " + (System.currentTimeMillis() - now) + " ms");
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)this.from("seda:foo?concurrentConsumers=50&size=250000").choice().when().xpath("//messageType = 'AAA' or //messageType = 'AAB' or //messageType = 'AAC' or //messageType = 'AAD' or //messageType = 'AAE' or //messageType = 'AAF' or //messageType = 'AAG' or //messageType = 'AAH' or //messageType = 'AAI' or //messageType = 'AAJ' or //messageType = 'AAK' or //messageType = 'AAL' or //messageType = 'AAM' or //messageType = 'AAN' or //messageType = 'AAO' or //messageType = 'AAP' or //messageType = 'AAQ' or //messageType = 'AAR' or //messageType = 'AAS' or //messageType = 'AAT' or //messageType = 'AAU' or //messageType = 'AAV' or //messageType = 'AAW' or //messageType = 'AAX' or //messageType = 'AAY' or //messageType = 'AAZ'")).to("mock:result")).otherwise().to("mock:other")).end();
            }
        };
    }
}

