/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.simple;

import java.util.HashMap;
import org.apache.camel.ExchangeTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.language.simple.SimpleExpressionParser;

public class SimpleParserExpressionTest
extends ExchangeTestSupport {
    public void testSimpleParserEol() throws Exception {
        SimpleExpressionParser parser = new SimpleExpressionParser("Hello", true);
        Expression exp = parser.parseExpression();
        SimpleParserExpressionTest.assertEquals((String)"Hello", (String)((String)exp.evaluate(this.exchange, String.class)));
    }

    public void testSimpleSingleQuote() throws Exception {
        SimpleExpressionParser parser = new SimpleExpressionParser("'Hello'", true);
        Expression exp = parser.parseExpression();
        SimpleParserExpressionTest.assertEquals((String)"'Hello'", (String)((String)exp.evaluate(this.exchange, String.class)));
    }

    public void testSimpleStringList() throws Exception {
        SimpleExpressionParser parser = new SimpleExpressionParser("\"Hello\" \"World\"", true);
        Expression exp = parser.parseExpression();
        SimpleParserExpressionTest.assertEquals((String)"\"Hello\" \"World\"", (String)((String)exp.evaluate(this.exchange, String.class)));
    }

    public void testSimpleSingleQuoteWithFunction() throws Exception {
        this.exchange.getIn().setBody((Object)"World");
        SimpleExpressionParser parser = new SimpleExpressionParser("'Hello ${body} how are you?'", true);
        Expression exp = parser.parseExpression();
        SimpleParserExpressionTest.assertEquals((String)"'Hello World how are you?'", (String)((String)exp.evaluate(this.exchange, String.class)));
    }

    public void testSimpleSingleQuoteWithFunctionBodyAs() throws Exception {
        this.exchange.getIn().setBody((Object)"World");
        SimpleExpressionParser parser = new SimpleExpressionParser("'Hello ${bodyAs(String)} how are you?'", true);
        Expression exp = parser.parseExpression();
        SimpleParserExpressionTest.assertEquals((String)"'Hello World how are you?'", (String)((String)exp.evaluate(this.exchange, String.class)));
    }

    public void testSimpleSingleQuoteEol() throws Exception {
        SimpleExpressionParser parser = new SimpleExpressionParser("'Hello' World", true);
        Expression exp = parser.parseExpression();
        SimpleParserExpressionTest.assertEquals((String)"'Hello' World", (String)((String)exp.evaluate(this.exchange, String.class)));
    }

    public void testSimpleFunction() throws Exception {
        this.exchange.getIn().setBody((Object)"World");
        SimpleExpressionParser parser = new SimpleExpressionParser("${body}", true);
        Expression exp = parser.parseExpression();
        SimpleParserExpressionTest.assertEquals((String)"World", (String)((String)exp.evaluate(this.exchange, String.class)));
    }

    public void testSimpleSingleQuoteDollar() throws Exception {
        SimpleExpressionParser parser = new SimpleExpressionParser("Pay 200$ today", true);
        Expression exp = parser.parseExpression();
        SimpleParserExpressionTest.assertEquals((String)"Pay 200$ today", (String)((String)exp.evaluate(this.exchange, String.class)));
    }

    public void testSimpleSingleQuoteDollarEnd() throws Exception {
        SimpleExpressionParser parser = new SimpleExpressionParser("Pay 200$", true);
        Expression exp = parser.parseExpression();
        SimpleParserExpressionTest.assertEquals((String)"Pay 200$", (String)((String)exp.evaluate(this.exchange, String.class)));
    }

    public void testSimpleUnaryInc() throws Exception {
        this.exchange.getIn().setBody((Object)"122");
        SimpleExpressionParser parser = new SimpleExpressionParser("${body}++", true);
        Expression exp = parser.parseExpression();
        SimpleParserExpressionTest.assertEquals((String)"123", (String)((String)exp.evaluate(this.exchange, String.class)));
    }

    public void testSimpleUnaryDec() throws Exception {
        this.exchange.getIn().setBody((Object)"122");
        SimpleExpressionParser parser = new SimpleExpressionParser("${body}--", true);
        Expression exp = parser.parseExpression();
        SimpleParserExpressionTest.assertEquals((String)"121", (String)((String)exp.evaluate(this.exchange, String.class)));
    }

    public void testSimpleUnaryIncInt() throws Exception {
        this.exchange.getIn().setBody((Object)122);
        SimpleExpressionParser parser = new SimpleExpressionParser("${body}++", true);
        Expression exp = parser.parseExpression();
        SimpleParserExpressionTest.assertEquals((Object)123, (Object)exp.evaluate(this.exchange, Integer.class));
    }

    public void testSimpleUnaryDecInt() throws Exception {
        this.exchange.getIn().setBody((Object)122);
        SimpleExpressionParser parser = new SimpleExpressionParser("${body}--", true);
        Expression exp = parser.parseExpression();
        SimpleParserExpressionTest.assertEquals((Object)121, (Object)exp.evaluate(this.exchange, Integer.class));
    }

    public void testHeaderNestedFunction() throws Exception {
        this.exchange.getIn().setBody((Object)"foo");
        this.exchange.getIn().setHeader("foo", (Object)"abc");
        SimpleExpressionParser parser = new SimpleExpressionParser("${header.${body}}", true);
        Expression exp = parser.parseExpression();
        Object obj = exp.evaluate(this.exchange, Object.class);
        SimpleParserExpressionTest.assertNotNull((Object)obj);
        SimpleParserExpressionTest.assertEquals((Object)"abc", (Object)obj);
    }

    public void testBodyAsNestedFunction() throws Exception {
        this.exchange.getIn().setBody((Object)"123");
        this.exchange.getIn().setHeader("foo", (Object)"Integer");
        SimpleExpressionParser parser = new SimpleExpressionParser("${bodyAs(${header.foo})}", true);
        Expression exp = parser.parseExpression();
        Object obj = exp.evaluate(this.exchange, Object.class);
        SimpleParserExpressionTest.assertNotNull((Object)obj);
        Integer num = SimpleParserExpressionTest.assertIsInstanceOf(Integer.class, obj);
        SimpleParserExpressionTest.assertEquals((int)123, (int)num);
    }

    public void testThreeNestedFunctions() throws Exception {
        this.exchange.getIn().setBody((Object)"123");
        this.exchange.getIn().setHeader("foo", (Object)"Int");
        this.exchange.getIn().setHeader("bar", (Object)"e");
        this.exchange.getIn().setHeader("baz", (Object)"ger");
        SimpleExpressionParser parser = new SimpleExpressionParser("${bodyAs(${header.foo}${header.bar}${header.baz})}", true);
        Expression exp = parser.parseExpression();
        Object obj = exp.evaluate(this.exchange, Object.class);
        SimpleParserExpressionTest.assertNotNull((Object)obj);
        Integer num = SimpleParserExpressionTest.assertIsInstanceOf(Integer.class, obj);
        SimpleParserExpressionTest.assertEquals((int)123, (int)num);
    }

    public void testNestedNestedFunctions() throws Exception {
        this.exchange.getIn().setBody((Object)"123");
        this.exchange.getIn().setHeader("foo", (Object)"Integer");
        this.exchange.getIn().setHeader("bar", (Object)"foo");
        SimpleExpressionParser parser = new SimpleExpressionParser("${bodyAs(${header.${header.bar}})}", true);
        Expression exp = parser.parseExpression();
        Object obj = exp.evaluate(this.exchange, Object.class);
        SimpleParserExpressionTest.assertNotNull((Object)obj);
        Integer num = SimpleParserExpressionTest.assertIsInstanceOf(Integer.class, obj);
        SimpleParserExpressionTest.assertEquals((int)123, (int)num);
    }

    public void testSimpleMap() throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("foo", "123");
        map.put("foo bar", "456");
        this.exchange.getIn().setBody(map);
        SimpleExpressionParser parser = new SimpleExpressionParser("${body[foo]}", true);
        Expression exp = parser.parseExpression();
        SimpleParserExpressionTest.assertEquals((Object)"123", (Object)exp.evaluate(this.exchange, Object.class));
        parser = new SimpleExpressionParser("${body['foo bar']}", true);
        exp = parser.parseExpression();
        SimpleParserExpressionTest.assertEquals((Object)"456", (Object)exp.evaluate(this.exchange, Object.class));
    }

    public void testUnaryLenient() throws Exception {
        this.exchange.getIn().setHeader("JMSMessageID", (Object)"JMSMessageID-123");
        this.exchange.getIn().setBody((Object)"THE MSG ID ${header.JMSMessageID} isA --");
        SimpleExpressionParser parser = new SimpleExpressionParser("THE MSG ID ${header.JMSMessageID} isA --", true);
        Expression exp = parser.parseExpression();
        SimpleParserExpressionTest.assertEquals((String)"THE MSG ID JMSMessageID-123 isA --", (String)((String)exp.evaluate(this.exchange, String.class)));
    }

    public void testUnaryLenient2() throws Exception {
        this.exchange.getIn().setHeader("JMSMessageID", (Object)"JMSMessageID-123");
        this.exchange.getIn().setBody((Object)"------------THE MSG ID ${header.JMSMessageID}------------");
        SimpleExpressionParser parser = new SimpleExpressionParser("------------THE MSG ID ${header.JMSMessageID}------------", true);
        Expression exp = parser.parseExpression();
        SimpleParserExpressionTest.assertEquals((String)"------------THE MSG ID JMSMessageID-123------------", (String)((String)exp.evaluate(this.exchange, String.class)));
    }

    public void testUnaryLenient3() throws Exception {
        this.exchange.getIn().setHeader("JMSMessageID", (Object)"JMSMessageID-123");
        this.exchange.getIn().setBody((Object)"------------ THE MSG ID ${header.JMSMessageID} ------------");
        SimpleExpressionParser parser = new SimpleExpressionParser("------------ THE MSG ID ${header.JMSMessageID} ------------", true);
        Expression exp = parser.parseExpression();
        SimpleParserExpressionTest.assertEquals((String)"------------ THE MSG ID JMSMessageID-123 ------------", (String)((String)exp.evaluate(this.exchange, String.class)));
    }
}

