/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.LoggingLevel;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.interceptor.Tracer;
import org.apache.camel.spi.InterceptStrategy;

public class ManagedCamelContextTracerTest
extends ManagementTestSupport {
    public void testCamelContextTracing() throws Exception {
        if (ManagedCamelContextTracerTest.isPlatform("aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName camel = ObjectName.getInstance("org.apache.camel:context=camel-1,type=context,name=\"camel-1\"");
        ObjectName on = new ObjectName("org.apache.camel:context=camel-1,type=tracer,name=Tracer");
        mbeanServer.isRegistered(camel);
        mbeanServer.isRegistered(on);
        MockEndpoint traced = this.getMockEndpoint("mock:traced");
        traced.setExpectedMessageCount(2);
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.setExpectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        Boolean tracing = (Boolean)mbeanServer.getAttribute(camel, "Tracing");
        ManagedCamelContextTracerTest.assertEquals((String)"Tracing should be enabled", (boolean)true, (boolean)tracing);
        String destinationUri = (String)mbeanServer.getAttribute(on, "DestinationUri");
        ManagedCamelContextTracerTest.assertEquals((String)"mock:traced", (String)destinationUri);
        String logLevel = (String)mbeanServer.getAttribute(on, "LogLevel");
        ManagedCamelContextTracerTest.assertEquals((String)LoggingLevel.OFF.name(), (String)logLevel);
        String logName = (String)mbeanServer.getAttribute(on, "LogName");
        ManagedCamelContextTracerTest.assertNotNull((Object)logName);
        Boolean logStackTrace = (Boolean)mbeanServer.getAttribute(on, "LogStackTrace");
        ManagedCamelContextTracerTest.assertEquals((Object)Boolean.FALSE, (Object)logStackTrace);
        Boolean traceInterceptors = (Boolean)mbeanServer.getAttribute(on, "TraceInterceptors");
        ManagedCamelContextTracerTest.assertEquals((Object)Boolean.FALSE, (Object)traceInterceptors);
        Boolean traceExceptions = (Boolean)mbeanServer.getAttribute(on, "TraceExceptions");
        ManagedCamelContextTracerTest.assertEquals((Object)Boolean.TRUE, (Object)traceExceptions);
        Boolean traceOutExchanges = (Boolean)mbeanServer.getAttribute(on, "TraceOutExchanges");
        ManagedCamelContextTracerTest.assertEquals((Object)Boolean.FALSE, (Object)traceOutExchanges);
        Boolean formatterShowBody = (Boolean)mbeanServer.getAttribute(on, "FormatterShowBody");
        ManagedCamelContextTracerTest.assertEquals((Object)Boolean.TRUE, (Object)formatterShowBody);
        Boolean formatterShowBodyType = (Boolean)mbeanServer.getAttribute(on, "FormatterShowBodyType");
        ManagedCamelContextTracerTest.assertEquals((Object)Boolean.TRUE, (Object)formatterShowBodyType);
        Boolean formatterShowOutBody = (Boolean)mbeanServer.getAttribute(on, "FormatterShowOutBody");
        ManagedCamelContextTracerTest.assertEquals((Object)Boolean.FALSE, (Object)formatterShowOutBody);
        Boolean formatterShowOutBodyType = (Boolean)mbeanServer.getAttribute(on, "FormatterShowOutBodyType");
        ManagedCamelContextTracerTest.assertEquals((Object)Boolean.FALSE, (Object)formatterShowOutBodyType);
        Boolean formatterShowBreadCrumb = (Boolean)mbeanServer.getAttribute(on, "FormatterShowBreadCrumb");
        ManagedCamelContextTracerTest.assertEquals((Object)Boolean.TRUE, (Object)formatterShowBreadCrumb);
        Boolean formatterShowExchangeId = (Boolean)mbeanServer.getAttribute(on, "FormatterShowExchangeId");
        ManagedCamelContextTracerTest.assertEquals((Object)Boolean.FALSE, (Object)formatterShowExchangeId);
        Boolean formatterShowHeaders = (Boolean)mbeanServer.getAttribute(on, "FormatterShowHeaders");
        ManagedCamelContextTracerTest.assertEquals((Object)Boolean.TRUE, (Object)formatterShowHeaders);
        Boolean formatterShowOutHeaders = (Boolean)mbeanServer.getAttribute(on, "FormatterShowOutHeaders");
        ManagedCamelContextTracerTest.assertEquals((Object)Boolean.FALSE, (Object)formatterShowOutHeaders);
        Boolean formatterShowProperties = (Boolean)mbeanServer.getAttribute(on, "FormatterShowProperties");
        ManagedCamelContextTracerTest.assertEquals((Object)Boolean.FALSE, (Object)formatterShowProperties);
        Boolean formatterShowNode = (Boolean)mbeanServer.getAttribute(on, "FormatterShowNode");
        ManagedCamelContextTracerTest.assertEquals((Object)Boolean.TRUE, (Object)formatterShowNode);
        Boolean formatterShowExchangePattern = (Boolean)mbeanServer.getAttribute(on, "FormatterShowExchangePattern");
        ManagedCamelContextTracerTest.assertEquals((Object)Boolean.TRUE, (Object)formatterShowExchangePattern);
        Boolean formatterShowException = (Boolean)mbeanServer.getAttribute(on, "FormatterShowException");
        ManagedCamelContextTracerTest.assertEquals((Object)Boolean.TRUE, (Object)formatterShowException);
        Boolean formatterShowShortExchangeId = (Boolean)mbeanServer.getAttribute(on, "FormatterShowShortExchangeId");
        ManagedCamelContextTracerTest.assertEquals((Object)Boolean.FALSE, (Object)formatterShowShortExchangeId);
        Integer formatterBreadCrumbLength = (Integer)mbeanServer.getAttribute(on, "FormatterBreadCrumbLength");
        ManagedCamelContextTracerTest.assertEquals((int)0, (int)formatterBreadCrumbLength);
        Integer formatterNodeLength = (Integer)mbeanServer.getAttribute(on, "FormatterNodeLength");
        ManagedCamelContextTracerTest.assertEquals((int)0, (int)formatterNodeLength);
        Integer formatterMaxChars = (Integer)mbeanServer.getAttribute(on, "FormatterMaxChars");
        ManagedCamelContextTracerTest.assertEquals((int)10000, (int)formatterMaxChars);
        mbeanServer.setAttribute(camel, new Attribute("Tracing", Boolean.FALSE));
        traced.reset();
        traced.setExpectedMessageCount(0);
        result.reset();
        result.setExpectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                Tracer tracer = new Tracer();
                tracer.setDestinationUri("mock:traced");
                tracer.setLogLevel(LoggingLevel.OFF);
                ManagedCamelContextTracerTest.this.context.addInterceptStrategy((InterceptStrategy)tracer);
                ((RouteDefinition)this.from("direct:start").to("log:foo")).to("mock:result");
            }
        };
    }
}

