/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;

public class ManagedRegisterEndpointTest
extends ManagementTestSupport {
    public void testLookupEndpointsByName() throws Exception {
        if (ManagedRegisterEndpointTest.isPlatform("aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName name = ObjectName.getInstance("org.apache.camel:context=camel-1,type=endpoints,name=\"direct://start\"");
        String uri = (String)mbeanServer.getAttribute(name, "EndpointUri");
        ManagedRegisterEndpointTest.assertEquals((String)"direct://start", (String)uri);
        name = ObjectName.getInstance("org.apache.camel:context=camel-1,type=endpoints,name=\"log://foo\"");
        uri = (String)mbeanServer.getAttribute(name, "EndpointUri");
        ManagedRegisterEndpointTest.assertEquals((String)"log://foo", (String)uri);
        name = ObjectName.getInstance("org.apache.camel:context=camel-1,type=endpoints,name=\"mock://result\"");
        uri = (String)mbeanServer.getAttribute(name, "EndpointUri");
        ManagedRegisterEndpointTest.assertEquals((String)"mock://result", (String)uri);
        String id = (String)mbeanServer.getAttribute(name, "CamelId");
        ManagedRegisterEndpointTest.assertEquals((String)"camel-1", (String)id);
        String state = (String)mbeanServer.getAttribute(name, "State");
        ManagedRegisterEndpointTest.assertEquals((String)"Started", (String)state);
        Boolean singleton = (Boolean)mbeanServer.getAttribute(name, "Singleton");
        ManagedRegisterEndpointTest.assertEquals((Object)Boolean.TRUE, (Object)singleton);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").to("log:foo")).to("mock:result");
            }
        };
    }
}

