/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;

public class ManagedRegisterRouteTest
extends ManagementTestSupport {
    public void testRoutes() throws Exception {
        if (ManagedRegisterRouteTest.isPlatform("aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=routes,*"), null);
        ManagedRegisterRouteTest.assertEquals((int)1, (int)set.size());
        ObjectName on = set.iterator().next();
        boolean registered = mbeanServer.isRegistered(on);
        ManagedRegisterRouteTest.assertEquals((String)"Should be registered", (boolean)true, (boolean)registered);
        String uri = (String)mbeanServer.getAttribute(on, "EndpointUri");
        ManagedRegisterRouteTest.assertEquals((String)"direct://start", (String)uri);
        Integer val = (Integer)mbeanServer.getAttribute(on, "InflightExchanges");
        ManagedRegisterRouteTest.assertEquals((int)0, (int)val);
        String state = (String)mbeanServer.getAttribute(on, "State");
        ManagedRegisterRouteTest.assertEquals((String)"Should be started", (String)ServiceStatus.Started.name(), (String)state);
        this.context.stopRoute((RouteDefinition)this.context.getRouteDefinitions().get(0));
        registered = mbeanServer.isRegistered(on);
        ManagedRegisterRouteTest.assertEquals((String)"Should be registered", (boolean)true, (boolean)registered);
        state = (String)mbeanServer.getAttribute(on, "State");
        ManagedRegisterRouteTest.assertEquals((String)"Should be stopped", (String)ServiceStatus.Stopped.name(), (String)state);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").to("log:foo")).to("mock:result");
            }
        };
    }
}

