/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.util.FileUtil;

public class ManagedStreamCachingStrategyTest
extends ManagementTestSupport {
    public void testStreamCachingStrategy() throws Exception {
        if (ManagedStreamCachingStrategyTest.isPlatform("aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=myCamel,type=services,*");
        Set<ObjectName> names = mbeanServer.queryNames(on, null);
        ObjectName name = null;
        for (ObjectName service : names) {
            if (!service.toString().contains("DefaultStreamCachingStrategy")) continue;
            name = service;
            break;
        }
        ManagedStreamCachingStrategyTest.assertNotNull((String)"Cannot find DefaultStreamCachingStrategy", name);
        Boolean enabled = (Boolean)mbeanServer.getAttribute(name, "Enabled");
        ManagedStreamCachingStrategyTest.assertEquals((Object)Boolean.TRUE, (Object)enabled);
        String dir = (String)mbeanServer.getAttribute(name, "SpoolDirectory");
        ManagedStreamCachingStrategyTest.assertEquals((String)FileUtil.normalizePath((String)"target/cachedir/myCamel"), (String)FileUtil.normalizePath((String)dir));
        Long threshold = (Long)mbeanServer.getAttribute(name, "SpoolThreshold");
        ManagedStreamCachingStrategyTest.assertEquals((long)131072L, (long)threshold);
        Integer size = (Integer)mbeanServer.getAttribute(name, "BufferSize");
        ManagedStreamCachingStrategyTest.assertEquals((int)4096, (int)size);
        Long counter = (Long)mbeanServer.getAttribute(name, "CacheMemoryCounter");
        ManagedStreamCachingStrategyTest.assertEquals((long)0L, (long)counter);
        counter = (Long)mbeanServer.getAttribute(name, "CacheSpoolCounter");
        ManagedStreamCachingStrategyTest.assertEquals((long)0L, (long)counter);
        Long cacheSize = (Long)mbeanServer.getAttribute(name, "CacheMemorySize");
        ManagedStreamCachingStrategyTest.assertEquals((long)0L, (long)cacheSize);
        cacheSize = (Long)mbeanServer.getAttribute(name, "CacheSpoolSize");
        ManagedStreamCachingStrategyTest.assertEquals((long)0L, (long)cacheSize);
        String chiper = (String)mbeanServer.getAttribute(name, "SpoolChiper");
        ManagedStreamCachingStrategyTest.assertNull((Object)chiper);
        Boolean remove = (Boolean)mbeanServer.getAttribute(name, "RemoveSpoolDirectoryWhenStopping");
        ManagedStreamCachingStrategyTest.assertEquals((Object)Boolean.TRUE, (Object)remove);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                DefaultCamelContext dcc = (DefaultCamelContext)ManagedStreamCachingStrategyTest.this.context;
                dcc.setName("myCamel");
                ManagedStreamCachingStrategyTest.this.context.setStreamCaching(Boolean.valueOf(true));
                ManagedStreamCachingStrategyTest.this.context.getStreamCachingStrategy().setSpoolDirectory("target/cachedir/#name#/");
                ((RouteDefinition)this.from("direct:start").routeId("foo").convertBodyTo(Integer.TYPE)).to("mock:a");
            }
        };
    }
}

