/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.ThreadPoolRejectedPolicy;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.spi.ThreadPoolProfile;

public class ManagedThreadPoolProfileTest
extends ManagementTestSupport {
    public void testManagedThreadPool() throws Exception {
        if (ManagedThreadPoolProfileTest.isPlatform("aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=threadpools,name=\"threads1(threads)\"");
        Boolean shutdown = (Boolean)mbeanServer.getAttribute(on, "Shutdown");
        ManagedThreadPoolProfileTest.assertEquals((boolean)false, (boolean)shutdown);
        Integer corePoolSize = (Integer)mbeanServer.getAttribute(on, "CorePoolSize");
        ManagedThreadPoolProfileTest.assertEquals((int)5, (int)corePoolSize);
        Integer maxPoolSize = (Integer)mbeanServer.getAttribute(on, "MaximumPoolSize");
        ManagedThreadPoolProfileTest.assertEquals((int)15, (int)maxPoolSize);
        Integer poolSize = (Integer)mbeanServer.getAttribute(on, "PoolSize");
        ManagedThreadPoolProfileTest.assertEquals((int)0, (int)poolSize);
        Long keepAlive = (Long)mbeanServer.getAttribute(on, "KeepAliveTime");
        ManagedThreadPoolProfileTest.assertEquals((int)25, (int)keepAlive.intValue());
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        String id = (String)mbeanServer.getAttribute(on, "Id");
        ManagedThreadPoolProfileTest.assertEquals((String)"threads1", (String)id);
        String source = (String)mbeanServer.getAttribute(on, "SourceId");
        ManagedThreadPoolProfileTest.assertEquals((String)"threads", (String)source);
        String routeId = (String)mbeanServer.getAttribute(on, "RouteId");
        ManagedThreadPoolProfileTest.assertEquals((String)"route1", (String)routeId);
        String profileId = (String)mbeanServer.getAttribute(on, "ThreadPoolProfileId");
        ManagedThreadPoolProfileTest.assertEquals((String)"custom", (String)profileId);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ThreadPoolProfile profile = new ThreadPoolProfile("custom");
                profile.setPoolSize(Integer.valueOf(5));
                profile.setMaxPoolSize(Integer.valueOf(15));
                profile.setKeepAliveTime(Long.valueOf(25L));
                profile.setMaxQueueSize(Integer.valueOf(250));
                profile.setRejectedPolicy(ThreadPoolRejectedPolicy.Abort);
                ManagedThreadPoolProfileTest.this.context.getExecutorServiceManager().registerThreadPoolProfile(profile);
                this.from("direct:start").threads().executorServiceRef("custom").to("mock:result");
            }
        };
    }
}

