/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Map;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.ServiceStatus;
import org.apache.camel.management.ManagementTestSupport;

public class ManagedUnregisterCamelContextTest
extends ManagementTestSupport {
    public void testUnregisterCamelContext() throws Exception {
        if (ManagedUnregisterCamelContextTest.isPlatform("aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=context,name=\"camel-1\"");
        ManagedUnregisterCamelContextTest.assertTrue((String)"Should be registered", (boolean)mbeanServer.isRegistered(on));
        String name = (String)mbeanServer.getAttribute(on, "CamelId");
        ManagedUnregisterCamelContextTest.assertEquals((String)"camel-1", (String)name);
        String state = (String)mbeanServer.getAttribute(on, "State");
        ManagedUnregisterCamelContextTest.assertEquals((String)ServiceStatus.Started.name(), (String)state);
        String version = (String)mbeanServer.getAttribute(on, "CamelVersion");
        ManagedUnregisterCamelContextTest.assertNotNull((Object)version);
        Map properties = (Map)mbeanServer.getAttribute(on, "Properties");
        ManagedUnregisterCamelContextTest.assertNull((Object)properties);
        Integer num = (Integer)mbeanServer.getAttribute(on, "InflightExchanges");
        ManagedUnregisterCamelContextTest.assertEquals((int)0, (int)num);
        this.context.stop();
        ManagedUnregisterCamelContextTest.assertFalse((String)"Should no longer be registered", (boolean)mbeanServer.isRegistered(on));
    }
}

