/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.TestSupport;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.DefaultCamelContextNameStrategy;
import org.apache.camel.management.DefaultManagementNamingStrategy;

public class TwoManagedCamelContextAutoAssignedNameClashTest
extends TestSupport {
    private CamelContext camel1;
    private CamelContext camel2;

    protected CamelContext createCamelContext() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext();
        DefaultManagementNamingStrategy naming = (DefaultManagementNamingStrategy)context.getManagementStrategy().getManagementNamingStrategy();
        naming.setHostName("localhost");
        naming.setDomainName("org.apache.camel");
        return context;
    }

    public void testTwoManagedCamelContextClash() throws Exception {
        if (TwoManagedCamelContextAutoAssignedNameClashTest.isPlatform("aix")) {
            return;
        }
        this.camel1 = this.createCamelContext();
        this.camel1.start();
        TwoManagedCamelContextAutoAssignedNameClashTest.assertTrue((String)"Should be started", (boolean)this.camel1.getStatus().isStarted());
        MBeanServer mbeanServer = this.camel1.getManagementStrategy().getManagementAgent().getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=" + this.camel1.getManagementName() + ",type=context,name=\"camel-1\"");
        TwoManagedCamelContextAutoAssignedNameClashTest.assertTrue((String)"Should be registered", (boolean)mbeanServer.isRegistered(on));
        DefaultCamelContextNameStrategy.setCounter((int)0);
        this.camel2 = this.createCamelContext();
        this.camel2.start();
        ObjectName on2 = ObjectName.getInstance("org.apache.camel:context=" + this.camel2.getManagementName() + ",type=context,name=\"camel-1\"");
        TwoManagedCamelContextAutoAssignedNameClashTest.assertTrue((String)"Should be registered", (boolean)mbeanServer.isRegistered(on2));
        TwoManagedCamelContextAutoAssignedNameClashTest.assertTrue((String)"Should still be registered after name clash", (boolean)mbeanServer.isRegistered(on));
        TwoManagedCamelContextAutoAssignedNameClashTest.assertTrue((String)"Should still be registered after name clash", (boolean)mbeanServer.isRegistered(on2));
    }

    protected void tearDown() throws Exception {
        if (this.camel1 != null) {
            this.camel1.stop();
        }
        if (this.camel2 != null) {
            this.camel2.stop();
        }
        super.tearDown();
    }
}

