/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.TestSupport;
import org.apache.camel.VetoCamelContextStartException;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.management.DefaultManagementNamingStrategy;

public class TwoManagedCamelContextClashTest
extends TestSupport {
    private CamelContext camel1;
    private CamelContext camel2;

    protected CamelContext createCamelContext(String name, String managementPattern) throws Exception {
        DefaultCamelContext context = new DefaultCamelContext();
        context.setName(name);
        if (managementPattern != null) {
            context.getManagementNameStrategy().setNamePattern(managementPattern);
        }
        DefaultManagementNamingStrategy naming = (DefaultManagementNamingStrategy)context.getManagementStrategy().getManagementNamingStrategy();
        naming.setHostName("localhost");
        naming.setDomainName("org.apache.camel");
        return context;
    }

    public void testTwoManagedCamelContextNoClashDefault() throws Exception {
        if (TwoManagedCamelContextClashTest.isPlatform("aix")) {
            return;
        }
        this.camel1 = this.createCamelContext("foo", null);
        this.camel2 = this.createCamelContext("foo", null);
        this.camel1.start();
        TwoManagedCamelContextClashTest.assertTrue((String)"Should be started", (boolean)this.camel1.getStatus().isStarted());
        MBeanServer mbeanServer = this.camel1.getManagementStrategy().getManagementAgent().getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=" + this.camel1.getManagementName() + ",type=context,name=\"foo\"");
        TwoManagedCamelContextClashTest.assertTrue((String)"Should be registered", (boolean)mbeanServer.isRegistered(on));
        this.camel2.start();
        ObjectName on2 = ObjectName.getInstance("org.apache.camel:context=" + this.camel2.getManagementName() + ",type=context,name=\"foo\"");
        TwoManagedCamelContextClashTest.assertTrue((String)"Should be registered", (boolean)mbeanServer.isRegistered(on2));
        TwoManagedCamelContextClashTest.assertTrue((String)"Should still be registered after name clash", (boolean)mbeanServer.isRegistered(on));
        TwoManagedCamelContextClashTest.assertTrue((String)"Should still be registered after name clash", (boolean)mbeanServer.isRegistered(on2));
    }

    public void testTwoManagedCamelContextNoClashCustomPattern() throws Exception {
        this.camel1 = this.createCamelContext("foo", "killer-#counter#");
        this.camel2 = this.createCamelContext("foo", "killer-#counter#");
        this.camel1.start();
        TwoManagedCamelContextClashTest.assertTrue((String)"Should be started", (boolean)this.camel1.getStatus().isStarted());
        MBeanServer mbeanServer = this.camel1.getManagementStrategy().getManagementAgent().getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=" + this.camel1.getManagementName() + ",type=context,name=\"foo\"");
        TwoManagedCamelContextClashTest.assertTrue((String)"Should be registered", (boolean)mbeanServer.isRegistered(on));
        this.camel2.start();
        ObjectName on2 = ObjectName.getInstance("org.apache.camel:context=" + this.camel2.getManagementName() + ",type=context,name=\"foo\"");
        TwoManagedCamelContextClashTest.assertTrue((String)"Should be registered", (boolean)mbeanServer.isRegistered(on2));
        TwoManagedCamelContextClashTest.assertTrue((String)"Should still be registered after name clash", (boolean)mbeanServer.isRegistered(on));
        TwoManagedCamelContextClashTest.assertTrue((String)"Should still be registered after name clash", (boolean)mbeanServer.isRegistered(on2));
    }

    public void testTwoManagedCamelContextClash() throws Exception {
        if (TwoManagedCamelContextClashTest.isPlatform("aix")) {
            return;
        }
        this.camel1 = this.createCamelContext("foo", "myFoo");
        this.camel2 = this.createCamelContext("foo", "myFoo");
        this.camel1.start();
        TwoManagedCamelContextClashTest.assertTrue((String)"Should be started", (boolean)this.camel1.getStatus().isStarted());
        MBeanServer mbeanServer = this.camel1.getManagementStrategy().getManagementAgent().getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=" + this.camel1.getManagementName() + ",type=context,name=\"foo\"");
        TwoManagedCamelContextClashTest.assertTrue((String)"Should be registered", (boolean)mbeanServer.isRegistered(on));
        try {
            this.camel2.start();
            TwoManagedCamelContextClashTest.fail((String)"Should have thrown an exception");
        }
        catch (VetoCamelContextStartException e) {
            TwoManagedCamelContextClashTest.assertTrue((boolean)e.getMessage().contains("is already registered"));
        }
    }

    protected void tearDown() throws Exception {
        if (this.camel1 != null) {
            this.camel1.stop();
        }
        if (this.camel2 != null) {
            this.camel2.stop();
        }
        super.tearDown();
    }
}

