/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.TestSupport;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.management.DefaultManagementNamingStrategy;

public class TwoManagedNamePatternTest
extends TestSupport {
    private CamelContext camel1;
    private CamelContext camel2;

    protected CamelContext createCamelContext(String name, String pattern) throws Exception {
        DefaultCamelContext context = new DefaultCamelContext();
        context.setName(name);
        context.getManagementNameStrategy().setNamePattern(pattern);
        DefaultManagementNamingStrategy naming = (DefaultManagementNamingStrategy)context.getManagementStrategy().getManagementNamingStrategy();
        naming.setHostName("localhost");
        naming.setDomainName("org.apache.camel");
        return context;
    }

    public void testManagedNamePattern() throws Exception {
        if (TwoManagedNamePatternTest.isPlatform("aix")) {
            return;
        }
        this.camel1 = this.createCamelContext("foo", "aaa-#name#");
        this.camel2 = this.createCamelContext("bar", "bbb-#name#");
        this.camel1.start();
        this.camel2.start();
        MBeanServer mbeanServer = this.camel1.getManagementStrategy().getManagementAgent().getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=aaa-foo,type=context,name=\"foo\"");
        TwoManagedNamePatternTest.assertTrue((String)"Should be registered", (boolean)mbeanServer.isRegistered(on));
        ObjectName on2 = ObjectName.getInstance("org.apache.camel:context=bbb-bar,type=context,name=\"bar\"");
        TwoManagedNamePatternTest.assertTrue((String)"Should be registered", (boolean)mbeanServer.isRegistered(on2));
        this.camel1.stop();
        this.camel2.stop();
        TwoManagedNamePatternTest.assertFalse((String)"Should be unregistered", (boolean)mbeanServer.isRegistered(on));
        TwoManagedNamePatternTest.assertFalse((String)"Should be unregistered", (boolean)mbeanServer.isRegistered(on2));
    }

    protected void tearDown() throws Exception {
        if (this.camel1 != null) {
            this.camel1.stop();
        }
        if (this.camel2 != null) {
            this.camel2.stop();
        }
        super.tearDown();
    }
}

