/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.io.InputStream;
import java.util.Collection;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RoutesDefinition;

public class LoadRouteFromXmlTest
extends ContextTestSupport {
    public void testLoadRouteFromXml() throws Exception {
        LoadRouteFromXmlTest.assertNotNull((String)"Existing foo route should be there", (Object)this.context.getRoute("foo"));
        LoadRouteFromXmlTest.assertEquals((int)1, (int)this.context.getRoutes().size());
        MockEndpoint foo = this.getMockEndpoint("mock:foo");
        foo.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:foo", (Object)"Hello World");
        foo.assertIsSatisfied();
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("barRoute.xml");
        RoutesDefinition routes = this.context.loadRoutesDefinition(is);
        this.context.addRouteDefinitions((Collection)routes.getRoutes());
        LoadRouteFromXmlTest.assertNotNull((String)"Loaded bar route should be there", (Object)this.context.getRoute("bar"));
        LoadRouteFromXmlTest.assertEquals((int)2, (int)this.context.getRoutes().size());
        MockEndpoint bar = this.getMockEndpoint("mock:bar");
        bar.expectedBodiesReceived(new Object[]{"Bye World"});
        this.template.sendBody("direct:bar", (Object)"Bye World");
        bar.assertIsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:foo").routeId("foo").to("mock:foo");
            }
        };
    }
}

