/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.Navigate;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.TryDefinition;
import org.apache.camel.processor.ChoiceProcessor;
import org.apache.camel.processor.SendProcessor;
import org.apache.camel.processor.TransformProcessor;

public class ChoiceWithEndTest
extends ContextTestSupport {
    public void testRouteIsCorrectAtRuntime() throws Exception {
        Navigate nav = this.getRoute("direct://start").navigate();
        List node = nav.next();
        ChoiceWithEndTest.assertEquals((int)4, (int)node.size());
        ChoiceWithEndTest.assertIsInstanceOf(SendProcessor.class, ChoiceWithEndTest.unwrapChannel((Processor)node.get(0)).getNextProcessor());
        ChoiceWithEndTest.assertIsInstanceOf(ChoiceProcessor.class, ChoiceWithEndTest.unwrapChannel((Processor)node.get(1)).getNextProcessor());
        ChoiceWithEndTest.assertIsInstanceOf(TransformProcessor.class, ChoiceWithEndTest.unwrapChannel((Processor)node.get(2)).getNextProcessor());
        ChoiceWithEndTest.assertIsInstanceOf(SendProcessor.class, ChoiceWithEndTest.unwrapChannel((Processor)node.get(3)).getNextProcessor());
    }

    private Route getRoute(String routeEndpointURI) {
        Route answer = null;
        for (Route route : this.context.getRoutes()) {
            if (!routeEndpointURI.equals(route.getEndpoint().getEndpointUri())) continue;
            answer = route;
            break;
        }
        return answer;
    }

    public void testChoiceHello() throws Exception {
        this.getMockEndpoint("mock:start").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:echo").expectedBodiesReceived(new Object[]{"echo Hello World"});
        this.getMockEndpoint("mock:last").expectedBodiesReceived(new Object[]{"last echo Hello World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testChoiceBye() throws Exception {
        this.getMockEndpoint("mock:start").expectedBodiesReceived(new Object[]{"Bye World"});
        this.getMockEndpoint("mock:bye").expectedBodiesReceived(new Object[]{"We do not care"});
        this.getMockEndpoint("mock:last").expectedBodiesReceived(new Object[]{"last We do not care"});
        this.template.sendBody("direct:start", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
    }

    public void testChoiceOther() throws Exception {
        this.getMockEndpoint("mock:start").expectedBodiesReceived(new Object[]{"Camel"});
        this.getMockEndpoint("mock:other").expectedBodiesReceived(new Object[]{"other Camel"});
        this.getMockEndpoint("mock:last").expectedBodiesReceived(new Object[]{"last other Camel"});
        this.template.sendBody("direct:start", (Object)"Camel");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                MyChoiceBean bean = new MyChoiceBean();
                ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((RouteDefinition)this.from("direct:start").to("mock:start")).choice().when(this.body().contains((Object)"Hello")).bean((Object)bean, "echo")).to("mock:echo")).when(this.body().contains((Object)"Bye")).to("direct:bye")).to("mock:bye")).otherwise().bean((Object)bean, "other")).to("mock:other")).end().transform((Expression)this.body().prepend((Object)"last ")).to("mock:last");
                ((TryDefinition)((TryDefinition)((TryDefinition)this.from("direct:bye").doTry().bean((Object)bean, "bye")).to("mock:bye")).doCatch(Exception.class).setBody((Expression)this.constant("We do not care"))).end();
            }
        };
    }

    public class MyChoiceBean {
        public String echo(String s) {
            return "echo " + s;
        }

        public String bye(String s) throws Exception {
            throw new IllegalArgumentException("Damn does not work");
        }

        public String other(String s) {
            return "other " + s;
        }
    }
}

