/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;

public class DefaultErrorHandlerCatchThrowableTest
extends ContextTestSupport {
    public void testDefaultErrorHandlerCatchThrowable() throws Exception {
        try {
            this.template.sendBody("direct:start", (Object)"Hello World");
            DefaultErrorHandlerCatchThrowableTest.fail((String)"Should have thrown exception");
        }
        catch (CamelExecutionException e) {
            DefaultErrorHandlerCatchThrowableTest.assertEquals((Object)"Hello World", (Object)e.getExchange().getIn().getBody());
            NoSuchMethodError cause = DefaultErrorHandlerCatchThrowableTest.assertIsInstanceOf(NoSuchMethodError.class, e.getCause());
            DefaultErrorHandlerCatchThrowableTest.assertEquals((String)"This is an Error not an Exception", (String)cause.getMessage());
        }
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                String exceptionString = "This is an Error not an Exception";
                this.from("direct:start").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        throw new NoSuchMethodError("This is an Error not an Exception");
                    }
                });
            }
        };
    }
}

