/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.PolicyDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.SetBodyDefinition;
import org.apache.camel.model.language.ConstantExpression;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.spi.Policy;
import org.apache.camel.spi.RouteContext;

public class DefinitionPolicyPerProcessorTest
extends ContextTestSupport {
    public void testDefintionAugmentationPolicy() throws Exception {
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.getMockEndpoint("mock:foo").expectedHeaderReceived("foo", (Object)"was wrapped");
        this.getMockEndpoint("mock:foo").expectedBodyReceived().constant((Object)"body was altered");
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        MyPolicy foo = (MyPolicy)this.context.getRegistry().lookupByNameAndType("foo", MyPolicy.class);
        DefinitionPolicyPerProcessorTest.assertEquals((String)"Should only be invoked 1 time", (int)1, (int)foo.getInvoked());
    }

    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("foo", (Object)new MyPolicy("foo"));
        return jndi;
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((PolicyDefinition)((ProcessorDefinition)this.from("direct:start").policy("foo").setBody().constant((Object)"body not altered")).to("mock:foo")).end();
            }
        };
    }

    public static class MyPolicy
    implements Policy {
        private final String name;
        private int invoked;

        public MyPolicy(String name) {
            this.name = name;
        }

        public int getInvoked() {
            return this.invoked;
        }

        public void beforeWrap(RouteContext routeContext, ProcessorDefinition<?> definition) {
            SetBodyDefinition bodyDef = (SetBodyDefinition)definition.getOutputs().get(0);
            bodyDef.setExpression((ExpressionDefinition)new ConstantExpression("body was altered"));
        }

        public Processor wrap(RouteContext routeContext, final Processor processor) {
            return new Processor(){

                public void process(Exchange exchange) throws Exception {
                    MyPolicy.this.invoked++;
                    exchange.getIn().setHeader(MyPolicy.this.name, (Object)"was wrapped");
                    processor.process(exchange);
                }
            };
        }
    }
}

