/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.CamelException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Processor;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.interceptor.HandleFault;
import org.apache.camel.spi.InterceptStrategy;

public class FaultRetryRouteTest
extends ContextTestSupport {
    protected MockEndpoint a;
    protected MockEndpoint b;
    protected MockEndpoint error;
    protected final Processor successOnRetryProcessor = new Processor(){
        int count;

        public void process(Exchange exchange) throws CamelException {
            if (this.count++ == 0) {
                exchange.getOut().setFault(true);
                exchange.getOut().setBody((Object)new CamelException("Failed the first time"));
            }
        }
    };

    public void testSuccessfulRetry() throws Exception {
        this.a.expectedBodiesReceived(new Object[]{"in"});
        this.b.expectedBodiesReceived(new Object[]{"in"});
        this.error.expectedMessageCount(0);
        this.template.sendBody("direct:start", (Object)"in");
        MockEndpoint.assertIsSatisfied((MockEndpoint[])new MockEndpoint[]{this.a, this.b, this.error});
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.a = this.resolveMandatoryEndpoint("mock:a", MockEndpoint.class);
        this.b = this.resolveMandatoryEndpoint("mock:b", MockEndpoint.class);
        this.error = this.resolveMandatoryEndpoint("mock:error", MockEndpoint.class);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() {
                this.getContext().addInterceptStrategy((InterceptStrategy)new HandleFault());
                this.errorHandler((ErrorHandlerBuilder)this.deadLetterChannel("mock:error").maximumRedeliveries(4).loggingLevel(LoggingLevel.DEBUG));
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").to("mock:a")).process(FaultRetryRouteTest.this.successOnRetryProcessor)).to("mock:b");
            }
        };
    }
}

