/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.io.File;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Header;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.OnCompletionDefinition;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.util.FileUtil;

public class FileRollbackOnCompletionTest
extends ContextTestSupport {
    private static final CountDownLatch LATCH = new CountDownLatch(1);

    @Override
    public void setUp() throws Exception {
        FileRollbackOnCompletionTest.deleteDirectory("target/mail/backup");
        super.setUp();
    }

    public void testOk() throws Exception {
        this.template.sendBodyAndHeader("direct:confirm", (Object)"bumper", "to", (Object)"someone@somewhere.org");
        File file = new File("target/mail/backup/");
        String[] files = file.list();
        FileRollbackOnCompletionTest.assertEquals((String)"There should be one file", (int)1, (int)files.length);
    }

    public void testRollback() throws Exception {
        try {
            this.template.sendBodyAndHeader("direct:confirm", (Object)"bumper", "to", (Object)"FATAL");
            FileRollbackOnCompletionTest.fail((String)"Should have thrown an exception");
        }
        catch (CamelExecutionException e) {
            FileRollbackOnCompletionTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause());
            FileRollbackOnCompletionTest.assertEquals((String)"Simulated fatal error", (String)e.getCause().getMessage());
        }
        this.oneExchangeDone.matchesMockWaitTime();
        FileRollbackOnCompletionTest.assertTrue((String)"Should countdown the latch", (boolean)LATCH.await(5L, TimeUnit.SECONDS));
        File file = new File("target/mail/backup/");
        String[] files = file.list();
        FileRollbackOnCompletionTest.assertEquals((String)"There should be no files", (int)0, (int)files.length);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((OnCompletionDefinition)this.from("direct:confirm").onCompletion().onFailureOnly().bean(FileRollback.class, "onFailure")).end().bean(OrderService.class, "createMail").log("Saving mail backup file").to("file:target/mail/backup").log("Trying to send mail to ${header.to}").bean(OrderService.class, "sendMail").log("Mail send to ${header.to}");
            }
        };
    }

    public static final class OrderService {
        public String createMail(String order) throws Exception {
            return "Order confirmed: " + order;
        }

        public void sendMail(String body, @Header(value="to") String to) {
            if (to.equals("FATAL")) {
                throw new IllegalArgumentException("Simulated fatal error");
            }
        }
    }

    public static final class FileRollback
    implements Synchronization {
        public void onComplete(Exchange exchange) {
        }

        public void onFailure(Exchange exchange) {
            String name = (String)exchange.getIn().getHeader("CamelFileNameProduced", String.class);
            FileUtil.deleteFile((File)new File(name));
            LATCH.countDown();
        }
    }
}

