/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.component.mock.MockEndpoint;

public class FilterTest
extends ContextTestSupport {
    public void testSendMatchingMessage() throws Exception {
        MockEndpoint resultEndpoint = this.resolveMandatoryEndpoint("mock:result", MockEndpoint.class);
        resultEndpoint.expectedMessageCount(1);
        ((ValueBuilder)resultEndpoint.message(0).property("CamelFilterMatched")).isEqualTo((Object)true);
        this.template.sendBodyAndHeader("direct:start", (Object)"<matched/>", "foo", (Object)"bar");
        resultEndpoint.assertIsSatisfied();
    }

    public void testSendNotMatchingMessage() throws Exception {
        MockEndpoint resultEndpoint = this.resolveMandatoryEndpoint("mock:result", MockEndpoint.class);
        resultEndpoint.expectedMessageCount(0);
        this.template.sendBodyAndHeader("direct:start", (Object)"<notMatched/>", "foo", (Object)"notMatchedHeaderValue");
        resultEndpoint.assertIsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").filter(this.header("foo").isEqualTo((Object)"bar")).to("mock:result");
            }
        };
    }
}

