/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;

public class InheritErrorHandlerFalseTest
extends ContextTestSupport {
    private static int counter;

    public void testInheritErrorHandlerFalse() throws Exception {
        counter = 0;
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.getMockEndpoint("mock:dead").expectedMessageCount(0);
        try {
            this.template.sendBody("direct:start", (Object)"Hello World");
            InheritErrorHandlerFalseTest.fail((String)"Should throw exception");
        }
        catch (Exception e) {
            IllegalArgumentException iae = InheritErrorHandlerFalseTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause());
            InheritErrorHandlerFalseTest.assertEquals((String)"Damn", (String)iae.getMessage());
        }
        this.assertMockEndpointsSatisfied();
        InheritErrorHandlerFalseTest.assertEquals((int)1, (int)counter);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.errorHandler((ErrorHandlerBuilder)this.deadLetterChannel("mock:dead").maximumRedeliveries(2));
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").process((Processor)new MyProcessor())).inheritErrorHandler(false)).to("mock:result");
            }
        };
    }

    public static class MyProcessor
    implements Processor {
        public void process(Exchange exchange) throws Exception {
            counter++;
            exchange.setException((Throwable)new IllegalArgumentException("Damn"));
        }
    }
}

