/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.io.StringWriter;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.LoggingLevel;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.SimpleRegistry;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Registry;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.slf4j.LoggerFactory;

public class LogProcessorWithProvidedLoggerTest
extends ContextTestSupport {
    private static StringWriter sw;
    private static StringWriter sw2;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        sw = new StringWriter();
        Logger.getLogger((String)"org.apache.camel.customlogger").removeAllAppenders();
        Logger.getLogger((String)"org.apache.camel.customlogger").addAppender((Appender)new CapturingAppender(sw));
        Logger.getLogger((String)"org.apache.camel.customlogger").setLevel(Level.TRACE);
    }

    public void testLogProcessorWithRegistryLogger() throws Exception {
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.template.sendBody("direct:foo", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
        Assert.assertThat((Object)sw.toString(), (Matcher)CoreMatchers.equalTo((Object)"org.apache.camel.customlogger INFO Got Bye World"));
    }

    public void testLogProcessorWithProvidedLogger() throws Exception {
        this.getMockEndpoint("mock:bar").expectedMessageCount(1);
        this.template.sendBody("direct:bar", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
        Assert.assertThat((Object)sw.toString(), (Matcher)CoreMatchers.equalTo((Object)"org.apache.camel.customlogger INFO Also got Bye World"));
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        SimpleRegistry registry = new SimpleRegistry();
        registry.put((Object)"mylogger1", (Object)LoggerFactory.getLogger((String)"org.apache.camel.customlogger"));
        DefaultCamelContext context = new DefaultCamelContext((Registry)registry);
        return context;
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:foo").routeId("foo").log(LoggingLevel.INFO, "Got ${body}")).to("mock:foo");
                ((RouteDefinition)this.from("direct:bar").routeId("bar").log(LoggingLevel.INFO, LoggerFactory.getLogger((String)"org.apache.camel.customlogger"), "Also got ${body}")).to("mock:bar");
            }
        };
    }

    private static final class CapturingAppender
    extends AppenderSkeleton {
        private StringWriter sw;

        private CapturingAppender(StringWriter sw) {
            this.sw = sw;
        }

        protected void append(LoggingEvent event) {
            this.sw.append(event.getLoggerName() + " " + event.getLevel().toString() + " " + event.getMessage());
        }

        public void close() {
        }

        public boolean requiresLayout() {
            return false;
        }
    }
}

