/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class MultiErrorHandlerInRouteNotHandledTest
extends ContextTestSupport {
    private MyProcessor outer = new MyProcessor();
    private MyProcessor inner = new MyProcessor();

    public void testNoErrors() throws Exception {
        this.outer.setName("Claus");
        this.inner.setName("James");
        this.getMockEndpoint("mock:inner").expectedMessageCount(0);
        this.getMockEndpoint("mock:outer").expectedMessageCount(0);
        MockEndpoint mock = this.getMockEndpoint("mock:end");
        mock.expectedHeaderReceived("name", (Object)"James");
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testOuterError() throws Exception {
        this.outer.setName("Error");
        this.inner.setName("James");
        this.getMockEndpoint("mock:inner").expectedMessageCount(0);
        MockEndpoint mock = this.getMockEndpoint("mock:outer");
        mock.expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testInnerError() throws Exception {
        this.outer.setName("Claus");
        this.inner.setName("Error");
        this.getMockEndpoint("mock:outer").expectedMessageCount(0);
        MockEndpoint mock = this.getMockEndpoint("mock:inner");
        mock.expectedHeaderReceived("name", (Object)"Claus");
        mock.expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").errorHandler((ErrorHandlerFactory)this.deadLetterChannel("mock:outer").maximumRedeliveries(1).redeliveryDelay(0L)).process((Processor)MultiErrorHandlerInRouteNotHandledTest.this.outer)).to("direct:outer");
                ((RouteDefinition)this.from("direct:outer").errorHandler((ErrorHandlerFactory)this.deadLetterChannel("mock:inner").maximumRedeliveries(2).redeliveryDelay(0L)).process((Processor)MultiErrorHandlerInRouteNotHandledTest.this.inner)).to("mock:end");
            }
        };
    }

    private static class MyProcessor
    implements Processor {
        private String name;

        private MyProcessor() {
        }

        public void process(Exchange exchange) throws Exception {
            if (this.name.equals("Error")) {
                throw new IllegalArgumentException("Forced exception by unit test");
            }
            exchange.getIn().setHeader("name", (Object)this.name);
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

