/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.MulticastDefinition;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.processor.aggregate.TimeoutAwareAggregationStrategy;

public class MulticastParallelAllTimeoutAwareTest
extends ContextTestSupport {
    private volatile Exchange receivedExchange;
    private volatile int receivedIndex;
    private volatile int receivedTotal;
    private volatile long receivedTimeout;

    public void testMulticastParallelAllTimeoutAware() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"AllTimeout"});
        this.template.sendBody("direct:start", (Object)"Hello");
        this.assertMockEndpointsSatisfied();
        MulticastParallelAllTimeoutAwareTest.assertNotNull((Object)this.receivedExchange);
        MulticastParallelAllTimeoutAwareTest.assertEquals((int)0, (int)this.receivedIndex);
        MulticastParallelAllTimeoutAwareTest.assertEquals((int)3, (int)this.receivedTotal);
        MulticastParallelAllTimeoutAwareTest.assertEquals((long)500L, (long)this.receivedTimeout);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((MulticastDefinition)this.from("direct:start").multicast((AggregationStrategy)new MyAggregationStrategy()).parallelProcessing().timeout(500L).to(new String[]{"direct:a", "direct:b", "direct:c"})).end().to("mock:result");
                this.from("direct:a").delay(1000L).setBody((Expression)this.constant("A"));
                this.from("direct:b").delay(2000L).setBody((Expression)this.constant("B"));
                this.from("direct:c").delay(1500L).setBody((Expression)this.constant("C"));
            }
        };
    }

    private class MyAggregationStrategy
    implements TimeoutAwareAggregationStrategy {
        private MyAggregationStrategy() {
        }

        public void timeout(Exchange oldExchange, int index, int total, long timeout) {
            MulticastParallelAllTimeoutAwareTest.this.receivedExchange = oldExchange;
            MulticastParallelAllTimeoutAwareTest.this.receivedIndex = index;
            MulticastParallelAllTimeoutAwareTest.this.receivedTotal = total;
            MulticastParallelAllTimeoutAwareTest.this.receivedTimeout = timeout;
            oldExchange.getIn().setBody((Object)"AllTimeout");
        }

        public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
            return oldExchange;
        }
    }
}

