/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.OnCompletionDefinition;
import org.apache.camel.model.RouteDefinition;

public class OnCompletionAsyncTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    public void testAsyncComplete() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((ExpressionNode)((OnCompletionDefinition)this.onCompletion().to("mock:before")).delay(1000L).setBody((Expression)this.simple("OnComplete:${body}"))).to("mock:after");
                ((RouteDefinition)this.from("direct:start").process((Processor)new MyProcessor())).to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:before").expectedBodiesReceived(new Object[]{"Bye World"});
        this.getMockEndpoint("mock:before").expectedPropertyReceived("CamelOnCompletion", (Object)true);
        this.getMockEndpoint("mock:after").expectedBodiesReceived(new Object[]{"OnComplete:Bye World"});
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Bye World"});
        String out = (String)this.template.requestBody("direct:start", (Object)"Hello World", String.class);
        OnCompletionAsyncTest.assertEquals((String)"Bye World", (String)out);
        this.assertMockEndpointsSatisfied();
    }

    public void testAsyncFailure() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((ExpressionNode)((OnCompletionDefinition)this.onCompletion().to("mock:before")).delay(1000L).setBody((Expression)this.simple("OnComplete:${body}"))).to("mock:after");
                ((RouteDefinition)this.from("direct:start").process((Processor)new MyProcessor())).to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:before").expectedBodiesReceived(new Object[]{"Kabom"});
        this.getMockEndpoint("mock:before").expectedPropertyReceived("CamelOnCompletion", (Object)true);
        this.getMockEndpoint("mock:after").expectedBodiesReceived(new Object[]{"OnComplete:Kabom"});
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(0);
        try {
            this.template.requestBody("direct:start", (Object)"Kabom");
            OnCompletionAsyncTest.fail((String)"Should throw exception");
        }
        catch (CamelExecutionException e) {
            OnCompletionAsyncTest.assertEquals((String)"Kabom", (String)e.getCause().getMessage());
        }
        this.assertMockEndpointsSatisfied();
    }

    public void testAsyncCompleteUseOriginalBody() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((ExpressionNode)((OnCompletionDefinition)this.onCompletion().useOriginalBody().to("mock:before")).delay(1000L).setBody((Expression)this.simple("OnComplete:${body}"))).to("mock:after");
                ((RouteDefinition)this.from("direct:start").process((Processor)new MyProcessor())).to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:before").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:before").expectedPropertyReceived("CamelOnCompletion", (Object)true);
        this.getMockEndpoint("mock:after").expectedBodiesReceived(new Object[]{"OnComplete:Hello World"});
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Bye World"});
        String out = (String)this.template.requestBody("direct:start", (Object)"Hello World", String.class);
        OnCompletionAsyncTest.assertEquals((String)"Bye World", (String)out);
        this.assertMockEndpointsSatisfied();
    }

    public void testAsyncFailureUseOriginalBody() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((ExpressionNode)((OnCompletionDefinition)this.onCompletion().useOriginalBody().to("mock:before")).delay(1000L).setBody((Expression)this.simple("OnComplete:${body}"))).to("mock:after");
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").transform((Expression)this.body().prepend((Object)"Before:${body}"))).process((Processor)new MyProcessor())).to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:before").expectedBodiesReceived(new Object[]{"Kabom"});
        this.getMockEndpoint("mock:before").expectedPropertyReceived("CamelOnCompletion", (Object)true);
        this.getMockEndpoint("mock:after").expectedBodiesReceived(new Object[]{"OnComplete:Kabom"});
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(0);
        try {
            this.template.requestBody("direct:start", (Object)"Kabom");
            OnCompletionAsyncTest.fail((String)"Should throw exception");
        }
        catch (CamelExecutionException e) {
            OnCompletionAsyncTest.assertEquals((String)"Kabom", (String)e.getCause().getMessage());
        }
        this.assertMockEndpointsSatisfied();
    }

    public void testAsyncCompleteOnCompleteFail() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((ExpressionNode)((ExpressionNode)((OnCompletionDefinition)this.onCompletion().to("mock:before")).delay(1000L).setBody((Expression)this.simple("OnComplete:${body}"))).throwException((Exception)new IllegalAccessException("From onComplete"))).to("mock:after");
                ((RouteDefinition)this.from("direct:start").process((Processor)new MyProcessor())).to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:before").expectedBodiesReceived(new Object[]{"Bye World"});
        this.getMockEndpoint("mock:before").expectedPropertyReceived("CamelOnCompletion", (Object)true);
        this.getMockEndpoint("mock:after").expectedMessageCount(0);
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Bye World"});
        String out = (String)this.template.requestBody("direct:start", (Object)"Hello World", String.class);
        OnCompletionAsyncTest.assertEquals((String)"Bye World", (String)out);
        this.assertMockEndpointsSatisfied();
    }

    public static class MyProcessor
    implements Processor {
        public void process(Exchange exchange) throws Exception {
            if (((String)exchange.getIn().getBody(String.class)).contains("Kabom")) {
                throw new IllegalArgumentException("Kabom");
            }
            exchange.getIn().setBody((Object)"Bye World");
        }
    }
}

