/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class PipelineMEPTest
extends ContextTestSupport {
    public void testInOnly() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{3});
        Exchange exchange = this.context.getEndpoint("direct:a").createExchange(ExchangePattern.InOnly);
        exchange.getIn().setBody((Object)1);
        Exchange out = this.template.send("direct:a", exchange);
        PipelineMEPTest.assertNotNull((Object)out);
        PipelineMEPTest.assertEquals((Object)ExchangePattern.InOnly, (Object)out.getPattern());
        this.assertMockEndpointsSatisfied();
        PipelineMEPTest.assertEquals((Object)ExchangePattern.InOnly, (Object)((Exchange)mock.getExchanges().get(0)).getPattern());
    }

    public void testInOut() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{3});
        Exchange exchange = this.context.getEndpoint("direct:a").createExchange(ExchangePattern.InOut);
        exchange.getIn().setBody((Object)1);
        Exchange out = this.template.send("direct:a", exchange);
        PipelineMEPTest.assertNotNull((Object)out);
        PipelineMEPTest.assertEquals((Object)ExchangePattern.InOut, (Object)out.getPattern());
        this.assertMockEndpointsSatisfied();
        PipelineMEPTest.assertEquals((Object)ExchangePattern.InOut, (Object)((Exchange)mock.getExchanges().get(0)).getPattern());
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        final Processor inProcessor = new Processor(){

            public void process(Exchange exchange) {
                Integer number = (Integer)exchange.getIn().getBody(Integer.class);
                if (number == null) {
                    number = 0;
                }
                number = number + 1;
                exchange.getIn().setBody((Object)number);
            }
        };
        final Processor outProcessor = new Processor(){

            public void process(Exchange exchange) {
                Integer number = (Integer)exchange.getIn().getBody(Integer.class);
                if (number == null) {
                    number = 0;
                }
                number = number + 1;
                exchange.getOut().setBody((Object)number);
            }
        };
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:a").process(outProcessor)).pipeline(new String[]{"log:x", "log:y"})).process(inProcessor)).to("mock:result");
            }
        };
    }
}

