/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;

public class RandomLoadBalanceTest
extends ContextTestSupport {
    protected MockEndpoint x;
    protected MockEndpoint y;
    protected MockEndpoint z;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.x = this.getMockEndpoint("mock://x");
        this.y = this.getMockEndpoint("mock://y");
        this.z = this.getMockEndpoint("mock://z");
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct://start").loadBalance().random().to(new String[]{"mock://x", "mock://y", "mock://z"});
            }
        };
    }

    public void testRandom() throws Exception {
        this.x.expectedMinimumMessageCount(5);
        this.y.expectedMinimumMessageCount(5);
        this.z.expectedMinimumMessageCount(5);
        for (int i = 0; i < 100; ++i) {
            this.template.sendBody("direct:start", (Object)"Hello World");
        }
        this.assertMockEndpointsSatisfied();
    }
}

