/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.Header;
import org.apache.camel.RecipientList;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;

public class RecipeientListWithSimpleExpressionTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Override
    protected void setUp() throws Exception {
        this.disableJMX();
        super.setUp();
    }

    public void testRecipientList() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").recipientList((Expression)this.simple("mock:${in.header.queue}"));
            }
        });
        this.context.start();
        for (int i = 0; i < 10; ++i) {
            this.getMockEndpoint("mock:" + i).expectedMessageCount(50);
        }
        ExecutorService executors = Executors.newFixedThreadPool(10);
        for (int i = 0; i < 50; ++i) {
            executors.execute(new Runnable(){

                @Override
                public void run() {
                    for (int i = 0; i < 10; ++i) {
                        RecipeientListWithSimpleExpressionTest.this.template.sendBodyAndHeader("direct:start", (Object)("Hello " + i), "queue", (Object)i);
                        try {
                            Thread.sleep(5L);
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            });
        }
        this.assertMockEndpointsSatisfied();
        executors.shutdownNow();
    }

    public void testStatic() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:0").to("mock:0");
                this.from("direct:1").to("mock:1");
                this.from("direct:2").to("mock:2");
                this.from("direct:3").to("mock:3");
                this.from("direct:4").to("mock:4");
                this.from("direct:5").to("mock:5");
                this.from("direct:6").to("mock:6");
                this.from("direct:7").to("mock:7");
                this.from("direct:8").to("mock:8");
                this.from("direct:9").to("mock:9");
            }
        });
        this.context.start();
        for (int i = 0; i < 10; ++i) {
            this.getMockEndpoint("mock:" + i).expectedMessageCount(50);
        }
        ExecutorService executors = Executors.newFixedThreadPool(10);
        for (int i = 0; i < 50; ++i) {
            executors.execute(new Runnable(){

                @Override
                public void run() {
                    for (int i = 0; i < 10; ++i) {
                        RecipeientListWithSimpleExpressionTest.this.template.sendBodyAndHeader("direct:" + i, (Object)("Hello " + i), "queue", (Object)i);
                        try {
                            Thread.sleep(5L);
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            });
        }
        this.assertMockEndpointsSatisfied();
        executors.shutdownNow();
    }

    public static class MyBeanRouter {
        @RecipientList
        public String route(@Header(value="queue") String queue) {
            return "mock:" + queue;
        }
    }
}

