/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.processor.BodyInAggregatingStrategy;
import org.apache.camel.processor.aggregate.AggregationStrategy;

public class RecipientListAggregationStrategyTest
extends ContextTestSupport {
    public void testRecipientListAggregationStrategy() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"a+b+c"});
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "foo", (Object)"direct:a,direct:b,direct:c");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").recipientList((Expression)this.header("foo")).aggregationStrategy((AggregationStrategy)new BodyInAggregatingStrategy()).to("mock:result");
                this.from("direct:a").transform((Expression)this.constant("a"));
                this.from("direct:b").transform((Expression)this.constant("b"));
                this.from("direct:c").transform((Expression)this.constant("c"));
            }
        };
    }
}

