/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;

public class RecipientListParallelStreamingTest
extends ContextTestSupport {
    public void testRecipientListParallel() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"c"});
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "foo", (Object)"direct:a,direct:b,direct:c");
        this.assertMockEndpointsSatisfied();
        mock.reset();
        mock.expectedBodiesReceived(new Object[]{"b"});
        this.template.sendBodyAndHeader("direct:streaming", (Object)"Hello World", "foo", (Object)"direct:a,direct:b,direct:c");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").recipientList((Expression)this.header("foo")).parallelProcessing().to("mock:result");
                this.from("direct:streaming").recipientList((Expression)this.header("foo")).parallelProcessing().streaming().to("mock:result");
                this.from("direct:a").delay(100L).transform((Expression)this.constant("a"));
                this.from("direct:b").delay(500L).transform((Expression)this.constant("b"));
                this.from("direct:c").transform((Expression)this.constant("c"));
            }
        };
    }
}

