/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.component.mock.MockEndpoint;

public class RecipientListWithStringDelimitedPropertyTest
extends ContextTestSupport {
    private static final String BODY = "answer";
    private static final String PROPERTY_VALUE = "mock:x, mock:y, mock:z";

    public void testSendingAMessageUsingMulticastReceivesItsOwnExchange() throws Exception {
        MockEndpoint x = this.getMockEndpoint("mock:x");
        MockEndpoint y = this.getMockEndpoint("mock:y");
        MockEndpoint z = this.getMockEndpoint("mock:z");
        x.expectedBodiesReceived(new Object[]{BODY});
        y.expectedBodiesReceived(new Object[]{BODY});
        z.expectedBodiesReceived(new Object[]{BODY});
        ((ValueBuilder)x.message(0).property("myProperty")).isEqualTo((Object)PROPERTY_VALUE);
        ((ValueBuilder)y.message(0).property("myProperty")).isEqualTo((Object)PROPERTY_VALUE);
        ((ValueBuilder)z.message(0).property("myProperty")).isEqualTo((Object)PROPERTY_VALUE);
        this.sendBody();
        this.assertMockEndpointsSatisfied();
    }

    protected void sendBody() {
        this.template.sendBodyAndProperty("direct:a", (Object)BODY, "myProperty", (Object)PROPERTY_VALUE);
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:a").recipientList((Expression)this.property("myProperty"));
            }
        };
    }
}

