/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;

public class RemoveHeaderTest
extends ContextTestSupport {
    private MockEndpoint end;
    private MockEndpoint mid;
    private String headerName = "foo";
    private String expectedHeaderValue = "bar";

    public void testSetHeaderMidRouteThenRemove() throws Exception {
        this.mid.expectedMessageCount(1);
        this.end.expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"<blah/>");
        this.assertMockEndpointsSatisfied();
        List midExchanges = this.mid.getExchanges();
        Exchange midExchange = (Exchange)midExchanges.get(0);
        String actualHeaderValue = (String)midExchange.getIn().getHeader(this.headerName, String.class);
        RemoveHeaderTest.assertEquals((String)this.expectedHeaderValue, (String)actualHeaderValue);
        List endExchanges = this.end.getExchanges();
        Exchange endExchange = (Exchange)endExchanges.get(0);
        RemoveHeaderTest.assertNull((Object)endExchange.getIn().getHeader(this.headerName, String.class));
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.end = this.getMockEndpoint("mock:end");
        this.mid = this.getMockEndpoint("mock:mid");
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)((RouteDefinition)((ProcessorDefinition)this.from("direct:start").setHeader(RemoveHeaderTest.this.headerName).constant((Object)RemoveHeaderTest.this.expectedHeaderValue)).to("mock:mid")).removeHeader(RemoveHeaderTest.this.headerName)).to("mock:end");
            }
        };
    }
}

