/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.processor.resequencer.MessageRejectedException;

public class ResequenceStreamRejectOldExchangesTest
extends ContextTestSupport {
    public void testInSequenceAfterCapacityReached() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"A", "B", "C", "E"});
        this.getMockEndpoint("mock:error").expectedMessageCount(0);
        this.template.sendBodyAndHeader("direct:start", (Object)"B", "seqno", (Object)2);
        this.template.sendBodyAndHeader("direct:start", (Object)"C", "seqno", (Object)3);
        this.template.sendBodyAndHeader("direct:start", (Object)"A", "seqno", (Object)1);
        this.template.sendBodyAndHeader("direct:start", (Object)"E", "seqno", (Object)5);
        this.assertMockEndpointsSatisfied();
    }

    public void testDuplicateAfterCapacityReached() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"A", "B", "C"});
        this.getMockEndpoint("mock:error").expectedMessageCount(0);
        this.template.sendBodyAndHeader("direct:start", (Object)"B", "seqno", (Object)2);
        this.template.sendBodyAndHeader("direct:start", (Object)"C", "seqno", (Object)3);
        this.template.sendBodyAndHeader("direct:start", (Object)"A", "seqno", (Object)1);
        this.template.sendBodyAndHeader("direct:start", (Object)"C", "seqno", (Object)3);
        this.assertMockEndpointsSatisfied();
    }

    public void testOutOfSequenceAfterCapacityReachedSimple() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"B", "C", "D"});
        this.getMockEndpoint("mock:error").expectedBodiesReceived(new Object[]{"A"});
        this.template.sendBodyAndHeader("direct:start", (Object)"D", "seqno", (Object)4);
        this.template.sendBodyAndHeader("direct:start", (Object)"C", "seqno", (Object)3);
        this.template.sendBodyAndHeader("direct:start", (Object)"B", "seqno", (Object)2);
        this.template.sendBodyAndHeader("direct:start", (Object)"A", "seqno", (Object)1);
        this.assertMockEndpointsSatisfied();
    }

    public void testOutOfSequenceAfterCapacityReachedComplex() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"A", "D", "E", "F"});
        this.getMockEndpoint("mock:error").expectedBodiesReceived(new Object[]{"B", "C"});
        this.template.sendBodyAndHeader("direct:start", (Object)"E", "seqno", (Object)5);
        this.template.sendBodyAndHeader("direct:start", (Object)"D", "seqno", (Object)4);
        this.template.sendBodyAndHeader("direct:start", (Object)"A", "seqno", (Object)1);
        Thread.sleep(500L);
        this.template.sendBodyAndHeader("direct:start", (Object)"B", "seqno", (Object)2);
        this.template.sendBodyAndHeader("direct:start", (Object)"C", "seqno", (Object)3);
        this.template.sendBodyAndHeader("direct:start", (Object)"F", "seqno", (Object)6);
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((OnExceptionDefinition)this.from("direct:start").onException(MessageRejectedException.class).maximumRedeliveries(0).handled(true).to("mock:error")).end().resequence((Expression)this.header("seqno")).stream().capacity(3).rejectOld().to("mock:result");
            }
        };
    }
}

