/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.spi.RouteStartupOrder;

public class RouteStartupOrderSimpleTest
extends ContextTestSupport {
    public void testRouteStartupOrder() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        DefaultCamelContext dcc = (DefaultCamelContext)this.context;
        List order = dcc.getRouteStartupOrder();
        RouteStartupOrderSimpleTest.assertEquals((int)2, (int)order.size());
        RouteStartupOrderSimpleTest.assertEquals((String)"direct://start", (String)((RouteStartupOrder)order.get(0)).getRoute().getEndpoint().getEndpointUri());
        RouteStartupOrderSimpleTest.assertEquals((String)"seda://foo", (String)((RouteStartupOrder)order.get(1)).getRoute().getEndpoint().getEndpointUri());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("seda:foo").startupOrder(2).routeId("b").to("mock:result");
                this.from("direct:start").startupOrder(1).routeId("a").to("seda:foo");
            }
        };
    }
}

