/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.model.RouteDefinition;

public class SendToNoErrorHandlerTest
extends ContextTestSupport {
    public void testSendToNoErrorHandler() throws Exception {
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.getMockEndpoint("mock:dead").expectedMessageCount(1);
        ((ValueBuilder)this.getMockEndpoint("mock:dead").message(0).property("CamelExceptionCaught")).isInstanceOf(IllegalArgumentException.class);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.errorHandler((ErrorHandlerBuilder)this.deadLetterChannel("mock:dead"));
                ((RouteDefinition)this.from("direct:start").to("direct:foo")).to("mock:result");
                ((RouteDefinition)this.from("direct:foo").errorHandler((ErrorHandlerFactory)this.noErrorHandler()).to("mock:foo")).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        throw new IllegalArgumentException("Forced");
                    }
                });
            }
        };
    }
}

