/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ProcessorDefinition;

public class SetHeaderTest
extends ContextTestSupport {
    protected String matchingBody = "<person name='James' city='London'/>";

    public void testSendMatchingMessage() throws Exception {
        MockEndpoint resultEndpoint = this.getMockEndpoint("mock:result");
        resultEndpoint.expectedMessageCount(1);
        this.sendBody("direct:start", this.matchingBody);
        this.assertMockEndpointsSatisfied();
        List list = resultEndpoint.getReceivedExchanges();
        Exchange exchange = (Exchange)list.get(0);
        Object value = exchange.getIn().getHeader("foo");
        SetHeaderTest.assertEquals((String)"foo header", (Object)"London", (Object)value);
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ProcessorDefinition)this.from("direct:start").unmarshal().string().setHeader("foo").xpath("/person[@name='James']/@city", String.class)).to("mock:result");
            }
        };
    }
}

