/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;

public class SimpleResultTypeRouteTest
extends ContextTestSupport {
    public void testSimpleResultTypeFoo() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:foo");
        mock.expectedMessageCount(1);
        ((ValueBuilder)mock.message(0).header("cool")).isInstanceOf(Boolean.class);
        ((ValueBuilder)mock.message(0).header("cool")).isEqualTo((Object)true);
        ((ValueBuilder)mock.message(0).header("fail")).isInstanceOf(String.class);
        ((ValueBuilder)mock.message(0).header("fail")).isEqualTo((Object)"true");
        this.template.sendBody("direct:foo", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testSimpleResultTypeBar() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:bar");
        mock.expectedMessageCount(1);
        ((ValueBuilder)mock.message(0).header("cool")).isInstanceOf(Boolean.class);
        ((ValueBuilder)mock.message(0).header("cool")).isEqualTo((Object)true);
        ((ValueBuilder)mock.message(0).header("fail")).isInstanceOf(String.class);
        ((ValueBuilder)mock.message(0).header("fail")).isEqualTo((Object)"true");
        this.template.sendBody("direct:bar", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)((RouteDefinition)this.from("direct:foo").setHeader("cool", (Expression)this.simple("true", Boolean.class))).setHeader("fail", (Expression)this.simple("true"))).to("mock:foo");
                ((RouteDefinition)((ProcessorDefinition)this.from("direct:bar").setHeader("cool").simple("true", Boolean.class)).setHeader("fail", (Expression)this.simple("true"))).to("mock:bar");
            }
        };
    }
}

