/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.ArrayList;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.SplitDefinition;

public class SplitRefCustomExpressionTest
extends ContextTestSupport {
    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("myCustomExpression", (Object)new MyCustomExpression());
        return jndi;
    }

    public void testSplitCustomExpression() throws Exception {
        this.getMockEndpoint("mock:split").expectedBodiesReceived(new Object[]{"A", "B", "C"});
        this.template.sendBody("direct:start", (Object)"A,B,C");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((SplitDefinition)this.from("direct:start").split().ref("myCustomExpression")).to("mock:split");
            }
        };
    }

    public static class MyCustomExpression
    implements Expression {
        public <T> T evaluate(Exchange exchange, Class<T> type) {
            String body = (String)exchange.getIn().getBody(String.class);
            String[] parts = body.split(",");
            ArrayList<String> list = new ArrayList<String>();
            for (String part : parts) {
                list.add(part);
            }
            return (T)list.iterator();
        }
    }
}

