/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.FilterDefinition;
import org.apache.camel.model.SplitDefinition;

public class SplitTokenizerTest
extends ContextTestSupport {
    public void testSplitTokenizerA() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:split");
        mock.expectedBodiesReceived(new Object[]{"Claus", "James", "Willem"});
        this.template.sendBody("direct:a", (Object)"Claus,James,Willem");
        this.assertMockEndpointsSatisfied();
    }

    public void testSplitTokenizerB() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:split");
        mock.expectedBodiesReceived(new Object[]{"Claus", "James", "Willem"});
        this.template.sendBodyAndHeader("direct:b", (Object)"Hello World", "myHeader", (Object)"Claus,James,Willem");
        this.assertMockEndpointsSatisfied();
    }

    public void testSplitTokenizerC() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:split");
        mock.expectedBodiesReceived(new Object[]{"Claus", "James", "Willem"});
        this.template.sendBody("direct:c", (Object)"Claus James Willem");
        this.assertMockEndpointsSatisfied();
    }

    public void testSplitTokenizerD() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:split");
        mock.expectedBodiesReceived(new Object[]{"[Claus]", "[James]", "[Willem]"});
        this.template.sendBody("direct:d", (Object)"[Claus][James][Willem]");
        this.assertMockEndpointsSatisfied();
    }

    public void testSplitTokenizerE() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:split");
        mock.expectedBodiesReceived(new Object[]{"<person>Claus</person>", "<person>James</person>", "<person>Willem</person>"});
        String xml = "<persons><person>Claus</person><person>James</person><person>Willem</person></persons>";
        this.template.sendBody("direct:e", (Object)xml);
        this.assertMockEndpointsSatisfied();
    }

    public void testSplitTokenizerEWithSlash() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:split");
        String xml = "<persons><person attr='/' /></persons>";
        mock.expectedBodiesReceived(new Object[]{"<person attr='/' />"});
        this.template.sendBody("direct:e", (Object)xml);
        mock.assertIsSatisfied();
        this.assertMockEndpointsSatisfied();
    }

    public void testSplitTokenizerF() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:split");
        mock.expectedBodiesReceived(new Object[]{"<person name=\"Claus\"/>", "<person>James</person>", "<person>Willem</person>"});
        String xml = "<persons><person/><person name=\"Claus\"/><person>James</person><person>Willem</person></persons>";
        this.template.sendBody("direct:f", (Object)xml);
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((SplitDefinition)this.from("direct:a").split().tokenize(",")).to("mock:split");
                ((SplitDefinition)this.from("direct:b").split().tokenize(",", "myHeader")).to("mock:split");
                ((SplitDefinition)this.from("direct:c").split().tokenize("(\\W+)\\s*", null, true)).to("mock:split");
                ((SplitDefinition)this.from("direct:d").split().tokenizePair("[", "]", true)).to("mock:split");
                ((SplitDefinition)this.from("direct:e").split().tokenizeXML("person")).to("mock:split");
                ((FilterDefinition)((SplitDefinition)this.from("direct:f").split().xpath("//person")).filter().simple("${body}")).to("mock:split");
            }
        };
    }
}

