/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.component.mock.MockEndpoint;

public class SplitterCompletedPropertyTest
extends ContextTestSupport {
    public void testSplitterCompleted() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:split");
        mock.expectedBodiesReceived(new Object[]{"Hello World", "Bye World", "Bye Moon"});
        ((ValueBuilder)mock.message(0).property("CamelSplitComplete")).isEqualTo((Object)false);
        ((ValueBuilder)mock.message(1).property("CamelSplitComplete")).isEqualTo((Object)false);
        ((ValueBuilder)mock.message(2).property("CamelSplitComplete")).isEqualTo((Object)true);
        this.template.sendBody("direct:start", (Object)"Hello World,Bye World,Bye Moon");
        this.assertMockEndpointsSatisfied();
    }

    public void testSplitterStreamingCompleted() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:split");
        mock.expectedBodiesReceived(new Object[]{"Hello World", "Bye World", "Bye Moon"});
        ((ValueBuilder)mock.message(0).property("CamelSplitComplete")).isEqualTo((Object)false);
        ((ValueBuilder)mock.message(1).property("CamelSplitComplete")).isEqualTo((Object)false);
        ((ValueBuilder)mock.message(2).property("CamelSplitComplete")).isEqualTo((Object)true);
        this.template.sendBody("direct:streaming", (Object)"Hello World,Bye World,Bye Moon");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").split((Expression)this.body().tokenize(",")).to("mock:split");
                this.from("direct:streaming").split((Expression)this.body().tokenize(",")).streaming().to("mock:split");
            }
        };
    }
}

