/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.ArrayList;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ExpressionNode;

public class SplitterNullBodyTest
extends ContextTestSupport {
    public void testSplitABC() throws Exception {
        this.getMockEndpoint("mock:split").expectedMessageCount(3);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"A,B,C");
        this.assertMockEndpointsSatisfied();
    }

    public void testSplitABCStreaming() throws Exception {
        this.getMockEndpoint("mock:split").expectedMessageCount(3);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:streaming", (Object)"A,B,C");
        this.assertMockEndpointsSatisfied();
    }

    public void testSplitEmptyList() throws Exception {
        this.getMockEndpoint("mock:split").expectedMessageCount(0);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        ArrayList list = new ArrayList();
        this.template.sendBody("direct:start", list);
        this.assertMockEndpointsSatisfied();
    }

    public void testSplitEmptyListStreaming() throws Exception {
        this.getMockEndpoint("mock:split").expectedMessageCount(0);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        ArrayList list = new ArrayList();
        this.template.sendBody("direct:streaming", list);
        this.assertMockEndpointsSatisfied();
    }

    public void testSplitNullBody() throws Exception {
        this.getMockEndpoint("mock:split").expectedMessageCount(0);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", null);
        this.assertMockEndpointsSatisfied();
    }

    public void testSplitNullBodyStreaming() throws Exception {
        this.getMockEndpoint("mock:split").expectedMessageCount(0);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:streaming", null);
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((ExpressionNode)this.from("direct:start").split((Expression)this.body()).to("mock:split")).end().to("mock:result");
                ((ExpressionNode)this.from("direct:streaming").split((Expression)this.body()).streaming().to("mock:split")).end().to("mock:result");
            }
        };
    }
}

