/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ExpressionNode;

public class SplitterStreamingErrorHandlingTest
extends ContextTestSupport {
    public void testSplitterStreamingNoError() throws Exception {
        this.getMockEndpoint("mock:a").expectedBodiesReceived(new Object[]{"A", "B", "C", "D", "E"});
        this.getMockEndpoint("mock:b").expectedBodiesReceived(new Object[]{"A", "B", "C", "D", "E"});
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"A,B,C,D,E"});
        this.template.sendBody("direct:start", (Object)"A,B,C,D,E");
        this.assertMockEndpointsSatisfied();
    }

    public void testSplitterStreamingWithError() throws Exception {
        this.getMockEndpoint("mock:a").expectedBodiesReceived(new Object[]{"A", "B", "Kaboom", "D", "E"});
        this.getMockEndpoint("mock:b").expectedBodiesReceived(new Object[]{"A", "B", "D", "E"});
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        try {
            this.template.sendBody("direct:start", (Object)"A,B,Kaboom,D,E");
            SplitterStreamingErrorHandlingTest.fail((String)"Should have thrown an exception");
        }
        catch (CamelExecutionException e) {
            SplitterStreamingErrorHandlingTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause());
            SplitterStreamingErrorHandlingTest.assertEquals((String)"Cannot do this", (String)e.getCause().getMessage());
        }
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((ExpressionNode)((ExpressionNode)((ExpressionNode)this.from("direct:start").split((Expression)this.body().tokenize(",")).streaming().to("mock:a")).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        String body = (String)exchange.getIn().getBody(String.class);
                        if ("Kaboom".equals(body)) {
                            throw new IllegalArgumentException("Cannot do this");
                        }
                    }
                })).to("mock:b")).end().to("mock:result");
            }
        };
    }
}

