/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;

public class ThrottlerNullEvalTest
extends ContextTestSupport {
    public void testNullEvalTest() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World", "Bye World"});
        this.getMockEndpoint("mock:dead").expectedBodiesReceived(new Object[]{"Kaboom"});
        this.template.sendBodyAndHeader("seda:a", (Object)"Hello World", "max", (Object)2);
        this.template.sendBodyAndHeader("seda:a", (Object)"Kaboom", "max", null);
        this.template.sendBodyAndHeader("seda:a", (Object)"Bye World", "max", (Object)2);
        this.assertMockEndpointsSatisfied();
    }

    public void testNoHeaderTest() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World", "Bye World"});
        this.getMockEndpoint("mock:dead").expectedBodiesReceived(new Object[]{"Kaboom"});
        this.template.sendBodyAndHeader("seda:a", (Object)"Hello World", "max", (Object)2);
        this.template.sendBody("seda:a", (Object)"Kaboom");
        this.template.sendBodyAndHeader("seda:a", (Object)"Bye World", "max", (Object)2);
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.errorHandler((ErrorHandlerBuilder)this.deadLetterChannel("mock:dead"));
                this.from("seda:a").throttle((Expression)this.header("max")).to("mock:result");
            }
        };
    }
}

