/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.RouteNode;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.management.InstrumentationProcessor;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.TracedRouteNodes;

public class TraceableUnitOfWorkTest
extends ContextTestSupport {
    public void testSendingSomeMessages() throws Exception {
        Object out = this.template.requestBody("direct:start", (Object)"Hello London");
        TraceableUnitOfWorkTest.assertEquals((Object)"Failed at: sendTo(Endpoint[bean://bar])", (Object)out);
    }

    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("foo", (Object)new MyFooBean());
        jndi.bind("bar", (Object)new MyBarBean());
        return jndi;
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.errorHandler((ErrorHandlerBuilder)this.deadLetterChannel("mock:error").redeliveryDelay(0L).maximumRedeliveries(3));
                TraceableUnitOfWorkTest.this.context.setTracing(Boolean.valueOf(true));
                this.onException(Exception.class).handled(true).process((Processor)new MyErrorProcessor());
                ((RouteDefinition)this.from("direct:start").to("bean:foo")).to("bean:bar");
            }
        };
    }

    public class MyBarBean {
        public void process(Exchange exchange) throws Exception {
            throw new IllegalArgumentException("Damm Bar");
        }
    }

    public class MyFooBean {
        public void process(Exchange exchange) throws Exception {
            exchange.getOut().setBody((Object)"Foo okay");
        }
    }

    private static class MyErrorProcessor
    implements Processor {
        private MyErrorProcessor() {
        }

        public void process(Exchange exchange) throws Exception {
            TracedRouteNodes traced = exchange.getUnitOfWork().getTracedRouteNodes();
            List list = traced.getNodes();
            Processor last = ((RouteNode)list.get(list.size() - 3)).getProcessor();
            if (last instanceof InstrumentationProcessor) {
                InstrumentationProcessor ip = (InstrumentationProcessor)last;
                last = ip.getProcessor();
            }
            exchange.getOut().setFault(true);
            exchange.getOut().setBody((Object)("Failed at: " + last.toString()));
        }

        public String toString() {
            return "MyErrorProcessor";
        }
    }
}

